(ns tradingview.template
  (:require
    [clojure.string :as str]
    [clj-time.core :as t]
    [clj-time.coerce :as c]
    [clojure.tools.logging :as log]
    [monger.collection :as mc]
    [mongo.db :refer [db]]
      ))

(defn load-template
  ([client_id user_id] ; LIST
  (-> (mc/find-maps db "tvtemplate"
          {:client_id client_id :user_id user_id}
          {:_id 0 :name 1 })
      ))
  ([client_id user_id chart_id] ; ONE
  (-> (mc/find-maps db "tvtemplate"
          {:client_id client_id :user_id user_id :chart_id chart_id}
          {:_id 0 :name 1 :content 1 })
      (first))))


; POST REQUEST: charts_storage_url/charts_storage_api_version/charts?client=client_id&user=user_id&chart=chart_id

(defn save-template
  [client_id user_id data]
    (let [query {:client_id client_id :user_id user_id :name (:name data)}
          doc (merge data query)
          ]
      (mc/update db "tvtemplate" query doc {:upsert true})
    ))

(defn modify-template--unused
  [client_id user_id chart_id data]
    (let [query {:client_id client_id :user_id user_id :chart_id chart_id}
          doc (merge data query)
          doc (merge doc {:timestamp (t/now)})]
    (mc/update db "tvtemplate" query doc {:upsert false})))

(defn delete-template
  [client_id user_id name]
  (mc/remove db "tvtemplate"
      {:client_id client_id :user_id user_id :name name}))

(comment




)
