(ns tradingview.search
  (:require
    [clojure.tools.logging :refer [info]]
    [clj-time.core :as t]
    [clj-time.coerce :as c]
    [clojure.string :as str]
    [mongo.series]
    [mongo.instrument :refer [load-symbol search-instrument]]
    [series.core]
    [tradingview.symbol :refer [tradingview-symbol-info]]
    ))


;https://demo_feed.tradingview.com/search?query=B&type=stock&exchange=NYSE&limit=10
;[{"symbol":"BLK","full_name":"BLK","description":"BlackRock, Inc.","exchange":"NYSE","type":"stock"},
;  {"symbol":"BA","full_name":"BA","description":"The Boeing Company","exchange":"NYSE","type":"stock"}]


(defn if-empty-default-value- [field default-value]
  (if (nil? field)
      default-value
      (if (= "" field)
          default-value
          field)))


(defn search-conversion [row]
  (-> row
      (tradingview-symbol-info)
      (clojure.set/rename-keys {:tradingview :full_name
                                :display :symbol})
      ))


(defn convert-search- [rows]
  (map search-conversion rows))




(defn tradingview-search-request
  "searches by name/symbol, gives list of symbols"
  [query type exchange limit]
  (-> query
      (search-instrument (if-empty-default-value- type "")  (if-empty-default-value- exchange "") limit)
      (convert-search-)
    ))


(comment
    ; SEARCH endpoints
    (search "C" "Index" "" 2)

)
