(ns styles.ssymbol
  (:require
    [clojure.string :as string]
    [thi.ng.strf.core :as f]
    [reagent.core :as r]
    [cljss.reagent :refer-macros [defstyled]]
    [cljss.core :as css :refer-macros [defstyles defkeyframes]])
  (:require-macros
    [cljss.core]
    [cljss.reagent]))

; https://github.com/clj-commons/cljss




(defstyled symbol-box :input ;[show-dropdown?]
  {;:width 100
   :border "1px solid green"
   :background-color (with-meta #(if % "orange" "MediumSeaGreen") :show-dropdown?)
   ;:background-color "yellow"
   ;:opacity 0.6
   :vertical-align "top"
   ;:margin 0
   ;:font-family "Helvetica Neue', Helvetica, Arial, sans-serif"
   ;:font-size "16px"
   ;:line-height 1.0;
   })

 (defstyled instrument-name :span
   {:display "inline-block"
    :color "blue"
    ;:float "left"
    :width "5cm"
    ;:padding-top "2px"
    :padding 10
    :max-width "5cm"
    :min-width "5cm"
    :overflow "hidden"
    ;:background-color "white"
    ;:opacity 0.8
    :white-space "nowrap" ; Prevents name wrapping to 3 lines
   })


; .styles_ssymbol__dropdown-container-G__30
; {position:absolute;background-color:white;z-index:999999;left:0;border:2px solid orange;padding:1px;width:15cm;}



(defstyled dropdowncontainer :div
  {:position "absolute"
   :background-color "yellow"
   :z-index 999999
   ;:top "100%"
   :left 0
   ;:right 0
   :border "5px solid lightblue"
   ;:padding "1px"
   ;:width "10cm"
 })


(defstyled category :span {
  :border "1px solid grey"
  ; "lightblue"
  :background-color (with-meta #(if % "green" "yellow") :is-selected)
  :min-width "2cm"
  :width "2cm"
  ;:padding 10
  :margin 40
  :color "blue"
  :text-align "center"
  :display "inline-block"
  :cursor "pointer"
  :align "left"
  :&:hover {:background-color "orange"}
})


; RESULTS -TABLE

(defstyled tr :tr
  {;:background-color "red"
   ;:height "1cm"
   "&:nth-child(even)" {:background-color "white" :opacity 0.8}
   "&:nth-child(odd)" {:background-color "grey" :opacity 0.8}
   :&:hover {:background-color "lightblue"}
   :cursor "pointer"
  })

(defstyled td :td ;[width]
  {;:width width
   ;:overflow "hidden"
   ;:textOverflow "ellipsis"
   :color "blue"
   :white-space "nowrap" ; Prevents name wrapping to 3 lines
   })


(defstyled portfolio-group :div
  {
    :background-color "lightblue"
    :display "inline-block"
    :width "8cm"
    :vertical-align "top"
  })

  (defstyled button-pf :button
    {
      :background-color "lightblue"
      :vertical-align "top"
      :text (with-meta #(if % "P" "S") :portfolio?)
    })
