(ns styles.seasonality
  (:require
    [clojure.string :as string]
    [thi.ng.strf.core :as f]
    [reagent.core :as r]
    [cljss.reagent :refer-macros [defstyled]]
    [cljss.core :as css :refer-macros [defstyles defkeyframes]])
  (:require-macros
    [cljss.core]
    [cljss.reagent]))

    ; https://github.com/clj-commons/cljss

(defstyled td :td
  {;:width width
   ;:overflow "hidden"
   ;:textOverflow "ellipsis"
   :&:hover {
      :cursor "pointer"
      :background-color "lightblue"
      ;:border "1px solid"
    }
   :color "blue"
   :white-space "nowrap" ; Prevents name wrapping to 3 lines
   :min-width "3cm"
   :text-align "right"
   :background-color (with-meta #(if % "green" "") :significant?)
   })


;; design system
(def colors
  {:blue   "#298FCA"
   :green  "#7BC86C"
   :orange "#FFB968"
   :red    "#EF7564"
   :yellow "#F5DD29"})

(defstyles text-styles [size]
  {:font-family "Helvetica Neue"
   :font-size   size})

(defstyles trade-group [bg]
  {:font-size "14px"
   :background-color "orange"
   :&:hover {:background-color "light-blue"}
   "&:nth-child(3)" {:color "blue"}})

(defstyles mygrid [] {
     :display "grid"
     :grid-template-columns "repeat(3, 1fr)"
     :grid-gap "10px"
     :grid-auto-rows "minmax(100px, auto)"
   })

(defstyles mycell [row column] {
     :grid-column column
     :grid-row row
   })
