(ns seasonality.views.tradegroup
  (:require
    [clojure.string :as string]
    [thi.ng.strf.core :as f]
    [reagent.core :as r]
    [cljss.core :as css]
    [helper.main :refer [gen-key]]
    [helper.main :refer [round-number]]
    [styles.seasonality :as styles]))

(defn add-win-or-loss- [trades]
   (map #(assoc % :w-l (if (> (:pl-realized %) 0) :win :loss)) trades))

(defn table-by-category- [name, categories]
  (let [categories-sorted (sort-by :symbol categories)]
    [:table
      [:tbody
        [:tr [:th {:class (styles/trade-group "green")} name] [:th "cum-pl"] ]
        (for [t categories-sorted]
          [:tr {:key (:symbol t)}
            [:td (:symbol t) ]
            [:td (round-number (:pl  t)) ]])]]))

(defn trade-groups [trades]
  (let [by-symbol (vec (map #( assoc {} :symbol (get % 0) :pl (reduce + (map :pl-realized (get % 1))))  (group-by :symbol trades)))
        by-month (vec (map #( assoc {} :symbol (get % 0) :pl (reduce + (map :pl-realized (get % 1))))  (group-by :month trades)))
        by-year (vec (map #( assoc {} :symbol (get % 0) :pl (reduce + (map :pl-realized (get % 1))))  (group-by :year trades)))
        by-win-loss (vec (map #( assoc {} :symbol (get % 0) :pl (reduce + (map :pl-realized (get % 1))))  (group-by :w-l (add-win-or-loss- trades))))
        by-direction (vec (map #( assoc {} :symbol (get % 0) :pl (reduce + (map :pl-realized (get % 1))))  (group-by :trade-dir  trades))) ]
  [:div {:class (styles/mygrid)}
    [:div {:class (styles/mycell 1 1)}
      [table-by-category- "symbol" by-symbol]
      [table-by-category- "win/loss" by-win-loss]
      [table-by-category- "direction" by-direction]
      [table-by-category-  "month" by-month]]
    [:div {:class (styles/mycell 1 2)}
      [table-by-category- "year" by-year]]
  ]))


(comment

  (def demo-trades [ {:symbol "DAX Index" :pl-realized 3.4 :trade-dir "long" :trend "down" :trade-type "cycle" :year 2000 :month 1 :cum-pl 7.1}
    {:symbol "DAX Index" :pl-realized -2.1 :trade-dir "long" :trend "down" :trade-type "cycle" :year 2000 :month 2 :cum-pl 8.3}
    {:symbol "AAX Index" :pl-realized 0.1 :trade-dir "short" :trend "down" :trade-type "cycle" :year 2000 :month 3 :cum-pl 9.1}
    {:symbol "AAX Index" :pl-realized 9.3 :trade-dir "long" :trend "down" :trade-type "cycle" :year 2000 :month 4 :cum-pl 5.044}
    {:symbol "DAX Index" :pl-realized -4.1 :trade-dir "short" :trend "down" :trade-type "cycle" :year 2000 :month 5 :cum-pl 17.12}
    {:symbol "SMI Index" :pl-realized 6.3 :trade-dir "long" :trend "down" :trade-type "cycle" :year 2000 :month 6 :cum-pl 12.123}])

    (sort-by :symbol demo-trades)

    (add-win-or-loss demo-trades)

  (trade-list demo-trades )

  (vec (map #( assoc {} :symbol (get % 0) :pl (reduce + (map :pl-realized (get % 1))))  (group-by :symbol demo-trades)))

  ; :pl (reduce + (:pl-realized (get 1 %)))


  )
