(ns seasonality.precalc
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [thi.ng.strf.core :as f]
    [comp.input :refer [atom-input]]
    [comp.combo :refer [combo]]
    [comp.fetchcomp :refer [fetch-data-container]]
    [helper.main :refer [round-number-digits]]
    [seasonality.helper :refer [abs]])
  (:require-macros
    [devcards.core :as dc :refer [defcard defcard-rg deftest dom-node]]))


(defn mean-item [item]
  (get-in item [:data :stats :all :mean]))

(defn symbol-one [props item]
  (let [mean (get-in item [:data :stats :all :mean])
        stddev (get-in item [:data :stats :all :stddev])
        count (get-in item [:data :stats :all :count])]
   [:a {:href (str "/#/analysis?symbol=" (:symbol item) "&strategy=seasonal")}
       [:p (:symbol item) (round-number-digits 1 mean) ]]
  ))

(defn symbol-list [list-name list]
  [:div
    [:h1 list-name]
    [:<>
      [:h1 "# " (count list )]
      (map-indexed (fn [idx val] [symbol-one {:key idx} val]) list)]])


(defn significant? [item]
  (let [mean (get-in item [:data :stats :all :mean])
        stddev (get-in item [:data :stats :all :stddev])]
    (> (abs mean) (* 0.5 stddev))
  ))

(defn long? [item]
    (let [mean (get-in item [:data :stats :all :mean])]
    (> mean 0)))


(defn seasonal-precalc-page [data]
  (let [significant (filter significant? data)
        longs  (sort-by mean-item > (filter long? significant))
        shorts (sort-by mean-item < (remove long? significant))]
  (fn []
    [:<>
      [:h1 "Precalculated Seasonality (by month)"]
      [:p (str "# with long enough timeseries: " (count data))]
      [:p (str "# with minimum risk/reward: " (count significant))]
      [:div {:style {:display "flex"}}
          [symbol-list "Long" longs]
          [symbol-list "Shorts" shorts]
      ]
    ])))

(defonce month (r/atom 10))

(defn set-month [m]
    (println "precalc month changed to: " m)
    (reset! month m))

(defn seasonality-precalc-page []
  (fn []
    [:<>
      [:h1 "Precalculated Seasonality (by month)"]
      [:span "month: " @month]
      [combo @month (range 1 13) set-month]
      [fetch-data-container :seasonal-precalc {:month @month} 
        seasonal-precalc-page ]]))
