(ns seasonality.listsim
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [thi.ng.strf.core :as f]

    [api.get :refer [get-data]]
    [comp.mytab :as mytab]
    [comp.input :refer [atom-input]]
    [seasonality.views.tradesummary :refer [trade-summary]]
    [seasonality.views.chart :refer [perfchart]]
    [seasonality.settings :refer [seasonality-simulation-settings default-settings]]
    [seasonality.helper :refer [trades-out-of-sample]]
    [seasonality.demodata :refer [demo-result]])
  (:require-macros
    ;[cljs.test :refer [is testing]]
    [devcards.core :as dc :refer [defcard defcard-rg deftest dom-node]]))

;; The "database" of your client side UI.
(def app-state
  (r/atom demo-result))


(defn update-trades! [trades]
   (r/rswap! app-state assoc :trades trades))


(defn update-year-end! [year] (r/rswap! app-state assoc :year-end year))


(defn run-simulation-portfolio [symbol settings]
  (let [{year-start :year-start year-end :year-end max-positions :max-positions
         min-risk-reward :min-risk-reward is-future :is-future} settings
         xxx (println "running simulation portfolio: " symbol " start:" year-start " end:" year-end)]
    (get-data :seasonal-simulate-list (assoc settings :symbol symbol)
       #(do (update-trades! %)
            (update-year-end! year-end))
         )))


(defn simulate-list [a-symbol]
  (let [settings (r/atom default-settings)
        ;a-symbol (r/atom "DAX Index")
        run-simulation #(run-simulation-portfolio @a-symbol @settings)

    trades (:trades @app-state)
        year-end (:year-end @app-state)
        trades-out (trades-out-of-sample trades year-end)
        has-out-of-sample (> (count trades-out) 0)
        trade-list (if has-out-of-sample trades-out trades)  ]
  [:div
   [seasonality-simulation-settings settings run-simulation]
   [mytab/my-tab
      "pl-stats"
      [:div
        [perfchart trades ]
        (if has-out-of-sample [perfchart trades-out ])
      ]
      "trades"
      [trade-summary trade-list]
   ]]))


(defn sim-app []
  (let [symbol (r/atom "DAX Index")]
    [:<>  ;FRAGEMENT does not render to the DOM.
       [atom-input symbol]
       [simulate-list symbol]]))

; DEV-CARD

(defonce symbol- (r/atom "DAX Index"))

(defcard-rg seasonality-list
 "enter symbol (and press enter)"
 [:<>  ;FRAGEMENT does not render to the DOM.
   [atom-input symbol-]
   [simulate-list symbol-]]
   symbol-
 {:inspect-data true :history true})


(comment

  (:trades @app-state)

  (update-year-start!  "2999")
  (:year-start @app-state)
  (js/parseInt (:year-start @app-state))

  (trades-out-of-sample)


  )
