(ns seasonality.helper
  (:require
    [clojure.string :as string]
    [thi.ng.strf.core :as f]
    ))


(defn abs [x]
    (if (> x 0) x (* -1 x)))

; ** OUT OF SAMPLE
(defn add-cum-pl [trades]
  (let [trades-not-empty (remove nil? trades)
        pl (map :pl-realized trades-not-empty)
        cum-pl (reductions + pl)
        zipped (map vector trades cum-pl)]
   (map #(assoc (get % 0) :cum-pl (get % 1))  zipped)
   ))


(defn trades-out-of-sample [trades year-end]
  (let [year-end-int (js/parseInt year-end)
        out? (not (= year-end-int 0))]
   (if out? (add-cum-pl (vec (filter #( > (:year %) year-end-int) trades)))
            nil)))
