(ns seasonal.test
  (:require
    [clj-time.core :as t]
    [clojure.test :refer :all]
    [seasonal.stats :as stats]
    [seasonal.print :as print]
    ))

(def ts1 [
  {:date (t/date-time 1990 10 31) :close 10.1 }
  {:date (t/date-time 1990 11 30) :close 11.2 }
  {:date (t/date-time 1990 12 31) :close 12.3 }

  {:date (t/date-time 1991  1 31) :close 15.0 }
  {:date (t/date-time 1991  2 28) :close 15.0 }
  {:date (t/date-time 1991  3 31) :close 15.0 }
  {:date (t/date-time 1991  4 30) :close 15.0 }
  {:date (t/date-time 1991  5 31) :close 15.0 }
  {:date (t/date-time 1991  6 30) :close 15.0 }
  {:date (t/date-time 1991  7 31) :close 15.0 }
  {:date (t/date-time 1991  8 31) :close 15.0 }
  {:date (t/date-time 1991  9 30) :close 10.0 }
  {:date (t/date-time 1991 10 31) :close 10.0 }
  {:date (t/date-time 1991 11 30) :close 10.0 }
  {:date (t/date-time 1991 12 31) :close 10.0 }

  {:date (t/date-time 1992  1 31) :close 10.0 }
  {:date (t/date-time 1992  2 28) :close 10.0 }
  {:date (t/date-time 1992  3 31) :close 10.0 }
  {:date (t/date-time 1992  4 30) :close 10.0 }
  {:date (t/date-time 1992  5 31) :close 12.0 }
  {:date (t/date-time 1992  6 30) :close 12.0 }
  {:date (t/date-time 1992  7 31) :close 12.0 }
  {:date (t/date-time 1992  8 31) :close 14.0 }
  {:date (t/date-time 1992  9 30) :close 14.0 }
  {:date (t/date-time 1992 10 31) :close 14.0 }
  {:date (t/date-time 1992 11 30) :close 20.0 }
  {:date (t/date-time 1992 12 31) :close 10.0 }
])

(defn m [ts year month]
   (first (filter #(and (= (:year %) year) (= (:month %) month)) ts)))

(deftest stats-transform-series
  (testing "Seasonal/stats"
     (let [ts (stats/get-transformed-series "test" ts1)
           a (m ts 1992 12)
           ;_ (println "a is:" a)
           ]
        (is (= (:chg-p-12 a) 100.0) "12m chg 1991-11 -> 19991-12 100%")
        (is (= (:chg-1 a) -50.0)))))


(comment ; *******************************************************************************

  (run-tests 'seasonal.test)

  (add-future-month [])
  (add-future-month demo-stats)
  (or (nil? demo-stats) (= (count demo-stats) 0))




(deftest test-request-ok
 (testing "BB ReferenceRequest - ok"
   (run-requests requests-ok true)))

(stats/get-transformed-series "DAX Index")
  (stats/get-transformed-series "test" ts1)

  (stats/timeseries-add-change-1-m ts1)

; TEST internal functions

  (defn chg12
    [timeseries]
    (stats/price-change timeseries 12 :chg12))
  (take 5 ( chg12 ( data/get-data "SX3P Index") ))

  (println (stats/add-month (stats/price-change ( data/get-data "SX3P Index") 6 :chg-6m) ) )

  (group-by :month (stats/add-month ( data/get-data "SX3P Index")) )

  (total-stddev {:up-3 {:stddev 5} :down-3 {:stddev 4} :bingo {:name "bongo"}})
  (reduce + [1 2 3 4 5])

  (add-change-month :bongo {:close 10} {:close 12})

  (def dummy-data [{:close 100 :d 1} {:close 100 :d 2} {:close 100 :d 3} {:close 100 :d 4}
                   {:close 100 :d 5} {:close 110 :d 6} {:close 110 :d 7} {:close 120 :d 8}
                   {:close 10 :d 9} {:close 12 :d 10} {:close 14 :d 11} {:close 20 :d 12}
                   {:close 10 :d 13} {:close 12 :d 14} {:close 14 :d 15} {:close 20 :d 16}
                   {:close 10 :d 17} {:close 12 :d 18} {:close 14 :d 19} {:close 20 :d 20}
                   {:close 10 :d 21} {:close 12 :d 22} {:close 14 :d 23} {:close 20 :d 24}
                   ])





  )
