(ns seasonal.job
  (:require
    [clojure.string :as str]
    [clj-time.core :as t]

    [mongo.calculation]
    [mongo.portfolio :refer [list-members]]
    [seasonal.print :as print]

    [seasonal.stats :as stats]
    [seasonal.trading :as trading]
  ))

(def default-options
  {:year-start 0, :year-end 0,
  :max-positions 1,
  :min-risk-reward 30,
  :is-future false})

(defn calculate-stats [symbol]
  (let [_ (println "calculating seasonality for " symbol)
        options default-options
        data (seasonal.stats/get-series-stats-optimal symbol options)
        c  {:type :seasonal
            :symbol symbol
            :data data}]
      (mongo.calculation/save c)
      {:seasonal-stats 1}
      ))

(defn filter-month [stats month]
  (map #(update-in % [:data :stats] stats/stats-1-month month) stats))


(defn load-stats
  ([]
   (mongo.calculation/load-all "seasonal"))
  ([month]
   (filter-month (mongo.calculation/load-all "seasonal") month)))

(comment

;; VERIFY ALGO
(defn demo [symbol]
  ((print/print-timeseries (take 5 (stats/get-transformed-series symbol)))
   ;(print/print-timeseries (stats/get-transformed-series-future symbol))
   (print/print-season-table (stats/get-series-stats symbol))
   (print/print-trades (trading/trade-symbol symbol))
 ))

(future (demo "DAX Index"))

;; SAVE TO DB
(calculate-stats "DAX Index")
(calculate-stats "VNA GY Equity")



(def test (first (load-stats)))
(println test)
(filter-month [test] 1)

(def x (load-stats))
(first x)

(take 5 x)
(filter-month (take 1200 x) 1)
(filter-month x 1)

(update-in {:data {}} [:data :stats] (fn[s] 1))


(stats/stats-1-month nil 1)

 (load-stats 1)

)
