(ns seasonal.demo
  (:require
    ;[import.list :refer [list-members]]
    [mongo.portfolio :refer [list-members]]
    [seasonal.stats :as stats]
    [seasonal.print :as print]
    [seasonal.trading :as trading]
   ))


(comment ;*********************************************************************

  ; TEST EXPORTED functions

    (->> "BP/ LN Equity"
        (stats/get-transformed-series)
        (take 5)
        )




    (-> "DAX Index"
        (stats/get-series-stats)
        ;(print/print-season-table)
        )

(data/get-data "DAX Index")
(stats/get-transformed-series "DAX Index")
(print/print-timeseries (stats/get-transformed-series-future "DAX Index" ))
(print/print-season-table (stats/get-series-stats "DAX Index"))
(trading/trade-symbol "DAX Index")
(trading/trade-symbol "ATX Index")
(trading/trade-list-cum-pl "dax")
(trading/trade-list-cum-pl "indices_many")


(def symbols ["SXAP Index" "SX3P Index" "DAX Index" "ATX Index" "SPX Index" ])


(print/print-trades( trading/trade-symbols symbols/symbols))

(defn trade-list [name & [options]]
  [name]
  (let [members (if (nil? name) [] (list-members name) )
        trades (if (nil? name) [] (trading/trade-symbols members options))
        trades-cum-pl (trading/add-cum-pl trades)]
    trades-cum-pl))


(trade-list "dax")
(trade-list "dax" { :year-start 1990 :year-end 2000})

;; TRADE PORTFOLIO
(trading/trade-list-cum-pl "dax")
(trading/trade-list-cum-pl "indices_many")
(def symbols ["SXAP Index" "SX3P Index" "DAX Index" "ATX Index" "SPX Index" ])


  (trade-list "dax")
  (trade-list "dax" { :year-start 1990 :year-end 2000})




) ;*********************************************************************
