(ns mongo.stats
  (:require
    [clojure.string :as str]
    [clj-time.core :as t]
    [clojure.tools.logging :as log]
    [monger.collection :as mc]
    [mongo.db :refer [db]]
      ))

(defn remove-stats
  "removes calculated statistics"
  []
  (mc/remove db "statistics"
             {  ;:symbol "bongo"
             } ))

(defn save-stats [history]
  (let [history-sanitized (update-in history [:stats :percentiles ] #(into (vector) %) )
        history-timestamped (assoc history-sanitized :save-date (t/now))
       ]
    (mc/update db "statistics" {:symbol (:symbol history)} history-timestamped  {:upsert true})))

(defn load-stats [symbol]
  (let [history (mc/find-one-as-map  db "statistics" { :symbol symbol })]
    (update-in history [:stats :percentiles] #(into (hash-map) %))
    ))

(defn browse-stats []
  (mc/find-maps db "statistics"
                {:current {:$ne nil}
                 "stats.sample-count" {:$gte 200}
                 }
                {:_id 0 :symbol 1 :current-valuation 1
                 ;:$orderby {:current-valuation 1
                  }
                 ))

(defn patch-stats-symbol [history]
  (update-in history [:stats :percentiles] #(into (hash-map) %))
  )

(defn patch-i [history]
   (update-in history [:i] first)
  )






(defn browse-stats-info []
  (let [report (mc/aggregate
                 db
                 "statistics"
                 [{:$match {:current {:$ne nil}
                            "stats.sample-count" {:$gte 200}
                            }}

                  {:$lookup
                   {:from         "instruments",
                    :localField   "symbol",
                    :foreignField "symbol",
                    :as           "i"}}

                  {:$project {
                              "_id"      0
                              "symbol" 1
                              :current-valuation 1
                              :current 1
                              :stats 1
                              "i.name"   1
                              "i.sector"   1
                              "i.industry"   1
                              "i.subindustry"   1
                              :loosing-year-prct 1
                              :median-sales-growth 1
                              }}
                  {:$sort { :current-valuation 1}}
                  ])
          report (map patch-stats-symbol report)
          report (map patch-i report)
        ]
    report
    ))

(comment

  ;** TESTS
  (save-stats {:symbol "bongo" :stats { :a 15 :b 30}})
  (load-stats "LHA GR Equity")

  (remove-stats )
  (count (browse-stats))
  (browse-stats-info )
)
