(ns mongo.setting
  (:require
    [clojure.tools.logging :refer [info]]
    [clj-time.core :as t]
    [clojure.string :as str]
    [monger.core :as mg]
    [monger.collection :as mc]
    [monger.joda-time]
    [mongo.db :refer [db]]
    ))

; ** SETTINGS ************************************************************************************

(defn save-setting [name data]
  (mc/update db "settings" {:name name} {:name name :data data} {:upsert true}))

(defn load-setting [name]
  (mc/find-one-as-map db "settings" {:name name}))

(comment
  (load-setting "reportfields")
)
