(ns job.hasdata
  (:require
    [clj-time.core :as t]
    [mongo.db :refer [db]]
    [series.core :refer [available-range load-series]]
    [mongo.report :refer [load-annual-reports-available-for-symbol]]
    [mongo.universe :refer [browse-equities]]
    [mongo.portfolio :refer [set-list]]
    [job.run :refer [run index]]
    ))

(defn hasdata
  ([symbol]
  (hasdata {:series-start-years 20
            :series-end-days 90
            :reports-annual-number 10}
            symbol
            ))
  ([settings symbol]
  (let [range (available-range symbol)
        xx (println "calculating " symbol)
        ;xx (println "range: " range)
        ok-series-start  (if (nil? (:start range))
                             false
                             (t/after? (.plusYears (t/now) (-(:series-start-years settings))) (:start range)))
        ok-series-end    (if (nil? (:end range))
                             false
                             (t/after? (:end range) (.plusDays (t/now) (-(:series-end-days settings))) ))
        report-symbols (load-annual-reports-available-for-symbol symbol)
        ok-reports-number (> (count report-symbols) (:reports-annual-number settings))
        ;xx (println report-symbols)
        ok {:ok-series-start ok-series-start
            :ok-series-end ok-series-end
            :ok-reports-number ok-reports-number}
        ok-all (every? #(get % 1) ok)
        ]
        (merge range ok {:ok ok-all
                         :symbol symbol} )
    )))



(defn calculate-ok-data-list [symbol-ok]
  (let [equities (browse-equities)
        symbols (map :symbol equities)
        data (map hasdata symbols)
        data-ok (filter #(= true (:ok %)) data)
        symbols-ok (map :symbol data-ok)
        xx (println "OK List count: " (count data-ok))
        ]
     (set-list symbol-ok symbols-ok)
    ))


(comment
  (hasdata "MSFT US Equity")
  (hasdata "CLNX SM Equity")

  (calculate-ok-data-list "OK List")

)
