(ns instrument.index
  (:require
    [reagent.core :as r]
    [api.get :refer [get-data]]
    [comp.mui :as mui]
    [comp.mytab :as mytab]
    [comp.table :as table]
    [comp.input :as cinput]
    [comp.button :as cbutton]))

(defn member-add [amembers psymbol msymbol]
  (println "member-add.." msymbol " to " psymbol)
  (get-data :portfolio-member-add {:symbol-portfolio psymbol :symbol-member msymbol}
      #(println "member added. " %))
  (reset! amembers (conj @amembers msymbol)))


(defn member-remove [amembers psymbol msymbol]
   (println "member-remove.." msymbol " from " psymbol)
   (get-data :portfolio-member-remove {:symbol-portfolio psymbol :symbol-member msymbol}
         (fn [data] (println "member removed. ")))
    (reset! amembers (remove #(= msymbol %) @amembers)))


(defn index-info [instrument]
  (let [psymbol (:symbol instrument)
        members (r/atom (:members instrument))
        esymbol (r/atom "")]
    (fn [instrument]
      [mui/paper
         [:h1 (str "Index/List Members for " psymbol)]
         [mui/table
            [mui/table-head
               [mui/table-row
                 [mui/table-cell "symbol"]]]
            (into [mui/table-body](for [msymbol @members]
              [mui/table-row
                 [mui/table-cell msymbol
                 [cbutton/confirming-delete-button
                     {:tooltip "you want to delete?"
                      :confirm-tooltip "are you sure?"
                      :on-delete #(member-remove members psymbol msymbol)}]]]))
            [mui/table-row
              [mui/table-cell
                 [cinput/atom-input esymbol]
                 [mui/button {:on-click #(member-add members psymbol @esymbol) } "Add Symbol to Portfolio"]]]]])))
