(ns import.splits
  (:require
    [clojure.tools.logging :refer [info]]
    [clj-time.core :as t]
    [mongo.db :refer [db]]
    [mongo.instrument]
    [bloomberg.data.splits :refer [get-equity-splits]]
     ))

(defn splits [symbol]
  (let [splits (first(get-equity-splits symbol))
        splits (assoc splits :split-save-date (t/now))]
    (do
      ;(println splits)
      (mongo.instrument/save-splits symbol splits)
      {:equity-splits 1})
    ))

(defn update-needed- [symbol]
  (let [existing-instrument (mongo.instrument/load-symbol symbol)
        save-dt (get-in existing-instrument [:split-save-date])
        ;xx (println save-dt (type save-dt))
        ;xx (println (t/now) (type (t/now) ))
        needs-update (or (nil? save-dt)
                         (t/after? (t/now) (.plusDays save-dt 90) ))
        ]
    needs-update
    ))

(defn splits? [symbol]
  (let [needed (update-needed- symbol)]
    (if needed (splits symbol)
               (do ;(println "splits up to date " symbol)
                   {:equity-splits 0}
                   ))
    ))

(comment

  ; splits
  (splits "AAPL US Equity")
  (splits-update-needed  "AAPL US Equity")

  ;(get-all-splits)

  )
