(ns import.report-missingfield
  (:require
    [clojure.data :as cljdata]
    [clj-time.core :as t]
    [clj-time.format :as fmt]         ; to sanitize report release-date

    [mongo.db :refer [db]]
    [mongo.report]
    [fundamental.report :refer [yearly-report?]]
    [bloomberg.data.report-individual :refer [get-one-report]]
    ))


(defn missing-fields
  "for a financial report in db, shows the fields that are missing, or empty array"
  [fields report]
  (let [existing (set (keys (:fields report)))
        wanted (set fields)
        diff (clojure.set/difference wanted existing )]
    diff ))

(defn bloomberg-load-missing-fields [report]
  (let [symbol (:symbol report)
        report-name (:period report)
        fields (into [] (:missing report))
        report-db (dissoc report :missing)
        xx (println "BLOOMBERG DOWNLOAD FIELDS: " fields " for:" symbol " " report-name )
        report-bloomberg (get-one-report symbol report-name fields)
        xx (println "bloomberg fields RCVD: " report-bloomberg)
        fields-merged (merge (:fields report-db) (:fields report-bloomberg))
        combined-report (assoc report-db :fields fields-merged)]
    ;(println "saving combined report " combined-report)
    (println "saving new fields" report-bloomberg)
     (mongo.report/modify-report combined-report)
         ))


(defn load-missing-report-fields [db symbol]
  (let [reports (mongo.report/load-reports-for-symbol db symbol)
        reports-yearly (filter yearly-report? reports)
        fields (mongo.report/get-report-fields db)
        reports-missing (map #(assoc % :missing (missing-fields fields %)) reports-yearly)
        xx (println "MISSING report-fields: " reports-missing)
        reports-todo (filter #(> (count (:missing %)) 0) reports-missing)
        ]
    ;(println (map :missing reports-todo))
    (map (partial bloomberg-load-missing-fields db)  reports-todo)
    ;(bloomberg-load-missing-fields db (first reports-todo))
    {:equity-report-missing 1}
    ))



(comment

  (println "difference: " (missing-fields [:revenue :cogs :admin] {:fields {:revenue 100 :cogs 50 :ebit 10}} ))
  (println "missing field count: " (count(missing-fields [:revenue :cogs :admin] {:fields {:revenue 100 :cogs 50 :ebit 10}})))
  (> 1 0)


  (load-missing-report-fields mongo/db "MO US Equity")

  (pipe missing-field/load-missing-report-fields one-symbol symbol-one-)
  (pipe missing-field/load-missing-report-fields one-symbol "AIR GY Equity")
  (pipe missing-field/load-missing-report-fields index symbol-index-)



)
