(ns import.list
  (:require
    [clojure.string :as str]
    [clojure.java.io :as io]
    [clj-time.core :as t]
    [mongo.instrument]
    ))


(defn list-names []
  (->> (mapv str (filter #(.isFile %) (file-seq (clojure.java.io/file "./resources/list"))))
       (map #(str/split % #"/"))
       (map last)
       (vec)))

(defn list-members [list-name]
  (let [filename (str "resources/list/" list-name)]
        (if (and (not(nil? list-name)) (not (= "" list-name)) (.exists (io/as-file filename)))
            (map #(clojure.string/replace % "\r" "")
                (-> (slurp filename)
                  (str/split #"\n")))
            nil)))

(defn list-members-raw [list-name]
  (let [filename (str "resources/list/" list-name)]
    (if (and (not(nil? list-name)) (not(= "" list-name)) (.exists (io/as-file filename)))
        (-> (slurp filename))
         "")))

(defn save-list [list-name members-text]
  (let [filename (str "resources/list/" list-name)]
    (spit filename members-text)))


(defn save-list-members [symbol members]
  (let [instrument {:symbol symbol
                    :name (str "CustomList " symbol)
                    :members members
                    :category "List"
                    :COUNT_INDEX_MEMBERS (count members)}]
    (mongo.instrument/update-instrument instrument)))


(defn import-txt-list [name]
  (let [members (list-members name)]
    (save-list-members (str name " List") members)))

(defn import-txt-lists []
  (let [list-names (list-names)]
    (map (partial import-txt-list) list-names)))

(comment

    ; TEST
  (list-names)
  (list-members "test")
  (list-members "airlines")

  (list-members  "test")
  (list-members-raw  "")

  (save-list "xxx" "DAX Index\nCWI AV Equity\nIIA AV Equity")

  ; ALL
  (import-txt-list "airlines")
  (import-txt-lists)

  )                                                         ;*******************************************************
