(ns import.index
  (:require
    [clojure.tools.logging :refer [info]]
    [clj-time.core :as t]
    [taoensso.tufte :as tufte :refer (defnp p profiled profile)]
    [mongo.instrument :refer [load-symbol]]
    [mongo.universe]
    [bloomberg.data.index :refer [get-index]]
   ))

; INDEX

(defn update-needed?-
  "updates index info (if needed)"
  [symbol]
  (let [existing-instrument (load-symbol symbol)
        name (get-in existing-instrument [:name])
        member-count (get-in existing-instrument [:COUNT_INDEX_MEMBERS])
        ;xx (println "NAME IS: " name)
        ;xx (println "DESCRIPTION IS: " description)
        needs-update  (or (nil? name)
                          (clojure.string/blank? name)
                          (nil? member-count)
                          (= member-count 0)
                          )]
    needs-update))


(defn index-info [symbol]
  (do (-> symbol
          (get-index)
          (mongo.instrument/update-instrument))
      {:index 1}))


(defn index-info? [symbol]
  (let [needs-update (update-needed?- symbol)]
    (if needs-update
        (do ;(info symbol "bond info downloading")
          (index-info symbol))
        (do ;(info symbol "bond info is up to date.")
            {:index 0}))))



(defn indices-no-field-index-members
  "downloads members for indices without members"
  []
  (let [indices (mongo.universe/browse-indices "Index")
        indices-no-members (filter #(nil? (:COUNT_INDEX_MEMBERS %)) indices)
        symbols (map :symbol indices-no-members)
        ]
    (println "indices: " (count indices) " no-field-index-members: " (count indices-no-members))
    symbols
  ))

(defn indices-no-members []
  (let [indices (mongo.universe/browse-indices-no-members)
        symbols (map :symbol indices)]
    symbols ))

(defn refresh-indices [symbols]
  (doall (map (partial index-info) symbols))
  {:index (count symbols)})


(defn refresh-indices-no-field []
   (refresh-indices (indices-no-field-index-members)))

(defn refresh-indices-no-members []
  (refresh-indices (indices-no-members)))



(comment

  ;europe
  (index-info "BE500 Index")
  (index-info "BE500E Index")
  (index-info "ATX Index")

  (index-info "HDAX Index")

  ; usa
  (index-info "TRAN Index")
  (index-info "SPX Index")

  (index-info "INJCJC Index") ; US Initial Jobless Claims

  ;sector
  (index-info "BBGOLD Index")
  (index-info "BBRSRGLD Index")
  (index-info "BBREIT Index")

  (index-info "BWORLD Index")
  ; Bloomberg World - Region
  (index-info "BWORLDPR Index")
  (index-info "BWORLDEU Index")
  (index-info "BWORLDUS Index")
  ; Bloomberg World - Sector
  (index-info "BWMING Index")
  (index-info "BWIRON Index")
  (index-info "BWAUTM Index")
  (index-info "BWREIT Index")


  (count (indices-no-members))
  (count (indices-no-field-index-members))

  (println (indices-no-members))
  (println (indices-no-field-index-members))

  (refresh-indices-no-field)
  (refresh-indices-no-members)

  ; INDEX
  (pipe index-desciptive one-symbol symbol-index-)

  )
