(ns import.bond
  (:require
    [clojure.tools.logging :refer [info]]
    [mongo.db :refer [db]]
    [mongo.instrument]
    [bloomberg.data.bond :refer [get-bond-info]]
  ))

(defn update-needed?-
  "updates bond info (if needed)"
  [symbol]
  (let [existing-instrument (mongo.instrument/load-symbol symbol)
        name (get-in existing-instrument [:name])
        isin (get-in existing-instrument [:ID_ISIN])
        needs-update  (or (nil? name)
                          (clojure.string/blank? name)
                          (nil? isin)
                          (vector? isin)
                          (clojure.string/blank? isin)
                          )
        ]
    needs-update
    ))


(defn bond-info [symbol]
  (do (-> symbol
          (get-bond-info)
          (mongo.instrument/update-instrument))
      {:bond 1}))

(defn bond-info? [symbol]
  (let [needs-update (update-needed?- symbol)]
    (if needs-update
        (do ;(info symbol "bond info downloading")
          (bond-info symbol)
            {:bond 1})
        (do ;(info symbol "bond info is up to date.")
            {:bond 0}))))


(comment

   (let [ed (bond-info? "AT2448856 Corp")]
            (println "update cost: " ed))

)
