(ns fundamental.group
  (:require
    [clojure.string :as str]
    [clojure.java.io :as io]
    [clj-time.core :as t]
    [clojure.tools.logging :as log]
    [clj-time.core :as t]
    [taoensso.tufte :as tufte :refer (defnp p profiled profile)]
    [com.stuartsierra.frequencies :as freq]
    [monger.collection :as mc]
    [mongo.db :refer [db]]
    [mongo.universe]
    [fundamental.metrics :refer [calculate-metrics-series]]
    ))

(defn add [consolidated date val]
  (if (nil? val)
    consolidated
    (update consolidated date #(conj % val))
    ))

(defn add-ts [field consolidated timeseries]
   (reduce #(add %1 (:date %2) (get-in %2 [:report-metrics field] nil)) consolidated timeseries))


(defn percentiles [one]
  (let [freq-map (frequencies (:vals one))
        stats (freq/stats freq-map :percentiles [20 35 50 65 80])
        ]
    (assoc one :stats stats)
    ;freq-map
    ;stats
    ))


(defn group-history [field symbols]
    (let [group-series (map #(calculate-metrics-series % :monthly) symbols)]
      ;(map #(println (:symbol %) (count %)) group-series)
      (->> (reduce (partial add-ts field)  {} group-series)
           (into [] )
           (map #(assoc {} :date (get % 0) :vals (get % 1)) )
           (sort-by :date)                                  ; result: sorted  [ {:date :vals} ]
           (map percentiles)
        )))


(defn save-stats [stats]
  (mc/update "statsportfolio" {:symbol (:symbol stats)} stats  {:upsert true}))


(defn symbols-industry [industry]
  (->> (mongo.universe/browse-equities {:industry industry})
       (map :symbol)
       ))


(defn calculate-industry-save [industry]
  (let [symbol-list (symbols-industry  industry)
        symbol (str industry " Industry")
        stats (group-history :price-sales symbol-list)
        symbol-stat {:symbol symbol :stats stats}
        x (println symbol-stat)
        ]
    (save-stats symbol-stat)))


(defn calculate-industries []
  (let [industries (mongo.universe/equity-industry )
        industries (remove #(>= 20 (:count %)) industries)
        ]
    industries))

(comment

  ; DEVELOPMENT TEST

  (update {} :a #(conj % "3"))
  (add {}(t/date-time 1986 10 30) 15.3 )

  (add-ts {} [ {:date (t/date-time 1986 10 30) :report-metrics {:sales 15.3} }
               {:date (t/date-time 1986 10 30) :report-metrics {:sales 5.3} }
              ; {:date (t/date-time 1986 11 30) :report-metrics {:sales 3.3} }
               {:date (t/date-time 1986 11 30) :report-metrics {:sales 7} }
              ])

    (->> {:a [1 2] :b [3 4]}
        (into [] )
        (map #(assoc {} :date (get % 0) :vals (get % 1)) )
      )

  (->> (percentiles {:date (t/date-time 1990 01 01) :vals [1 3 4 5 6 4 4 433 34 4 4 4 4 44 ] })
       (assoc {:symbol "XXX"} :stats )
       (println)
       (save-stats)
    )

  (map percentiles [ {:date (t/date-time 1990 01 01) :vals [1 3 4 5 6] }
                     {:date (t/date-time 1990 01 01) :vals [1 3 4 5 6]}
                     {:date (t/date-time 1990 01 01) :vals [1 3 4 5 6]}
                     {:date (t/date-time 1990 01 01) :vals [1 3 4 5 6]}
                    ])

  ; ALGORITHM

  (group-history :price-sales ["LHA GR Equity" "MCD UN Equity"])

  (group-history :price-sales (:members (mongo.instrument/load-symbol "DAX Index")))

  (calculate-industries)

  (symbols-industry "Gas")

  (calculate-industry-save "Gas")



  )
