(ns financials.views.splits
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [comp.table :refer [my-table]]
    ))

(def table-fields [
  [:DeclaredDate "Declared"]
  [:Ex-Date "ExDate"]
  [:RecordDate "RecordDate"]
  [:PayableDate "PayableDate"]
  [:DividendAmount "DividendAmount"]
  [:DividendFrequency "DividendFrequency"]
  [:DividendType "DividendType"]])


(defn dividend-splits-table [instrument]
  (let [splits (get-in instrument [:EQY_DVD_HIST_SPLITS])]
    (if splits
          [my-table table-fields splits]
          [:h1 "No Splits"]
   )))
