(ns financials.views.reports
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [thi.ng.strf.core :as f]
    [helper.main :refer [round-number-digits gen-key]]
    [comp.input :refer [atom-input atom-selector int-input bool-input]]
    [styles.analysis :refer [master menu strategy button-goto]]
    [comp.table :as table]
    [comp.mui :as mui]
    [fieldinfo.view :as fieldinfo]
    [financials.views.reports-ag :refer [financial-reports-ag inject-data]]
  ))


(defn year-headers [header]
  [:tr {:key (gen-key)}
    [:th {:key (gen-key)} ""]
    (for [m (:period header)]
    [:th {:key (gen-key) :class m} m])])

(defn one-row [props data field show-digits]
  (let [row-field-value-vec ((keyword (:symbol field)) data)] ; get column-field-value-vector for the specified field
  [:tr props ;(:symbol field)

    ; Field Name for one Row
    [:td {:key (gen-key) :class (str "color-" (:class field))}
         [fieldinfo/field-name field]]

    ; Field Values for one Row
    ;(for [r ((keyword (:symbol field)) data)]
    ;  ^{:key r} [:td {:class (str "color-" (:class field))} (round-number r)] )
    (map-indexed (fn [i r]
         ;(println "row " i " size" (count row-field-value-vec))
         [:td {:key (gen-key) ; i
               :class (str "color-" (:class field))}
               [:span (round-number-digits show-digits r)]
              ])
         row-field-value-vec)
   ]))

(defn rows-in-group
  [data group show-digits]
  [:<> {:key (gen-key)} ; fragment (needed because we return a vector)
    (for [field (get group 1)]                    ;field-rows in group
      ;[:p {:key (gen-key)} "row1"]
      [one-row {:key (gen-key)} data field show-digits]
      )])

(defn report-groups
  [data field-groups show-digits]
  [:<> {:key (gen-key)} ; fragment (needed because we return a vector)
  (for [group field-groups]
    [:<> {:key (gen-key)}                 ; fragment (does not render to dom)
       ; genreate blue header for first-row
       [:tr {:key (gen-key) ; (get group 0)
             :style {:height "1cm" :color  "blue"}}
            ; [:br]
            ;[mui/divider]
            ]
       (vec [rows-in-group data group show-digits])
    ])])

(defn financial-report-list
  "multi-year reports with fields for one equity"
  [report field-groups show-digits]
    (let [header (if (nil? report) {} (get report 0))
          data   (if (nil? report) {} (get report 1))]
    [:table
       [:tbody
          [year-headers header]
          [report-groups data field-groups show-digits]
       ]]))


(defonce show-per-share (r/atom true))

(defn convert-field [field]
  {:symbol (keyword (:symbol field))
   :name (:name field)
   :category (:category field)
  })

(defn flatten-fields [field-groups]
  (let [group-members (vals field-groups)
        fields (vec (flatten group-members))
        fields (map convert-field fields)]
    fields
  ))


(defn report-switcher [report-main field-groups]
  (let [show-per-share? @show-per-share
        show-digits (if show-per-share? 1 0)
        ;xx (println "per share is: " show-per-share?)
       report (if show-per-share? (:per-share report-main) (:nominal report-main))]
      [master
        [menu
          [bool-input show-per-share]
          ;[:span (str "bool value " @show-per-share)]
          [:span "per share (vs nominal)"]]
        [strategy
          ;[financial-report-list report field-groups show-digits]
          [financial-reports-ag (inject-data (flatten-fields field-groups) {:periods (:period (get report 0)) :rows (get report 1)}) show-digits  ]]
      ]))
