(ns financials.ratio
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [thi.ng.strf.core :as f]
    [api.get :refer [get-data]]
    [app.quant.db :refer [set-current-page]]
    [helper.main :refer [round-number round-number-digits]]
    [financials.core]
    [comp.mui :as mui]
    [comp.table :as table]
    [comp.input :as input]
  ))


(def app-state
  (r/atom
    {
     :symbol ""
     :data  []
     }))

(defn update-symbol! [symbol]
      (r/rswap! app-state assoc :symbol symbol))

(defn update-data! [data]
      (r/rswap! app-state assoc :data data))



(defn get-data-one [symbol]
  (let [xxx (println "getting financial ratio history for instrument: " symbol)
        xxx (update-symbol! symbol)]
        (get-data :financial-ratio-stats {:symbol symbol} #(do (update-data! %)
                                     (println "ratio data received: " %)))
          ))

(defn get-data-all []
  (let [xxx (println "getting financial ratio history PRECALC." )]
    (get-data :ratio-stats-all  #(do (update-data! %)
                               (println "ratio data received: ")))))

;{:on-click routes/go-to-financials }
;nil nil routes/go-to-financials

(defn go-to-report [row]
  (println "going to report")
  (println "args are:" row)
  (set-current-page :financials)
  (financials.core/request-data (:symbol row))
  )

(defn ratio-history-table [data]
      [:div
       [:p (str "Monthly Series (with ratios)" )]
       [table/my-table
        [
          [[:i :name] "Name" nil nil go-to-report]
          [:symbol "Symbol"]
          [[:i :sector] "Sector"]
          [[:i :industry] "Industry"]
          [:current "Current" (partial round-number-digits 2) ]
          [:current-valuation "State"  ]
          [:loosing-year-prct "%Loss" (partial round-number-digits 0) ]
          [:median-sales-growth "MedRevGrow" (partial round-number-digits 1) ]
          [[:stats :percentiles :20]  "20" (partial round-number-digits 2) ]
          [[:stats :percentiles :40]  "40" (partial round-number-digits 2) ]
          [[:stats :percentiles :60]  "60" (partial round-number-digits 2) ]
          [[:stats :percentiles :80]  "80" (partial round-number-digits 2) ]

           ]
        data  ]
       ])


(defn ratio-page []
  (let [symbol (r/atom "")
        symbolApp (:symbol @app-state)
        data (:data @app-state)]
        [:div

         [:p
          [:button {:on-click #(get-data-all)} "Precalculated!"]]

         [:p "Symbol: " [input/atom-input symbol]
           [:button {:on-click #(get-data-one  @symbol)} "Go!"]]

         [:p (str "Ratio History for " symbolApp)]
         [mui/divider]
         [ratio-history-table data]


         ]))
