(ns financials.core
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [thi.ng.strf.core :as f]
    [api.get :refer [get-data]]
    [helper.reagent :refer [fetch-update]]
    [comp.mui :as mui]
    [comp.mytab :as mytab]
    [comp.table :as table]
    [comp.input :refer [atom-input atom-selector int-input bool-input]]

    [financials.chart :refer [valuation-chart]]
    [financials.views.reports :refer [financial-report-list report-switcher]]
    ;[financials.views.metrics :refer [monthly-metrics]]    ; Interchangeable with metrics-ag :-)
    [financials.views.metrics-ag :refer [monthly-metrics]]
    ;[instrument.equity :as equity]
    [financials.views.splits :refer [dividend-splits-table]])
  (:require-macros
      [devcards.core :as dc :refer [defcard defcard-rg deftest dom-node]]))

(def app-state
  (r/atom
   {
     :fields {:list [{:symbol "EBIT" :name "EBIT"  :position 1}]
              :groups []}
     :symbol-fetched ""
     :result {:report nil
              :series {:series []
                       :stats {}}
              :instrument {}
             }
     :valuation-showing "report-metrics.price-sales"
   }))

(defn save-fields [fields]
  (let [fields (sort-by :position fields)
        groups (group-by :category fields)]
    (r/rswap! app-state assoc :fields {:list fields :groups groups})))

(do (println "fetching financial-fields once.")
   (get-data :financial-fields save-fields))


(defn request-data [symbol]
 (do (println "financials run:" symbol)
     (r/rswap! app-state assoc :symbol-fetched symbol)
     (fetch-update app-state :report :financial-equity {:symbol symbol})
     (fetch-update app-state :series :financial-metric-series {:symbol symbol :interval "monthly"})
     ;(fetch-update app-state :instrument :instrument  {:symbol symbol})
     ))


(defn get-data-if-needed [symbol]
 (let [fetched-symbol (:symbol-fetched @app-state)]
   (if-not (= symbol fetched-symbol)
      (do (.log js/console "Getting Data for " symbol " ; prior symbol was: " fetched-symbol)
          (request-data symbol)))))


(defn financials-page [symbol]
  (fn [symbol]
    (let [xx (get-data-if-needed symbol)
          result (:result @app-state)]
     [:<>
        ;[get-data-if-needed symbol]
        [mytab/my-tab
          "chart"   [valuation-chart (:series result)]
          "metrics" [monthly-metrics (get-in result [:series :series]) ]
          "reports" [report-switcher (:report result) (get-in @app-state [:fields :groups])]
          "splits"  [dividend-splits-table (:instrument result)]
          ;"info"          [equity-info (:instrument result)]
          ]
     ])))


(defn process-row [ [field data]]
  (println field (count data)))

(defn print-report-rows [report-type]
  (let [current-report (report-type (:report @app-state))
        rows (last current-report)]
     (map process-row rows)
    ))

; DEV-CARD

(defonce symbol- (r/atom "BP/ LN Equity"))

(defcard-rg finance
  "enter symbol (and press enter)"
  (fn [symbol-] [:<>  ;FRAGEMENT does not render to the DOM.
       [atom-input symbol-]
       [financials-page @symbol-]])
       symbol-
  {:inspect-data true :history true})
