(ns financials.chart
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [thi.ng.strf.core :as f]
    [comp.mui :as mui]
    [comp.table :as table]
    [comp.input :refer [atom-input atom-selector int-input bool-input]]
    [financials.views.oz :as oz]
   ))

(def available-fields- [
  "report-metrics.shares-adj"
  "report-metrics.turnover-mc"
  "report-metrics.turnover"
  "report-metrics.sales"
  "report-metrics.price-sales"
  "report-metrics.sales-growth"

  "report-metrics.ebit"
  "report-metrics.price-ebit"
  "report-metrics.ebit-margin"

  "report-metrics.price-book"
  "report-metrics.price-earnings"
  "report-metrics.dividend-yield"

  "report-metrics.asset-yield"
  "report-metrics.ev"
  "report-metrics.ev-ebit"
  "report-metrics.debt-ebit"
  ])


  (defonce valuation-field (r/atom "report-metrics.price-sales") )
  (defonce range-min (r/atom 0))
  (defonce range-max (r/atom 20))
  (defonce range-enabled (r/atom false))


(defn valuation-chart [series]
  [:div#valuation-chart
   [atom-selector valuation-field available-fields-]
   [int-input range-min]
   [int-input range-max]
   [bool-input range-enabled]
   [mui/divider]
   [oz/finance-plot series @valuation-field @range-min @range-max @range-enabled]
   ])
