(ns fieldinfo.view
  (:require
    [reagent.core :refer [atom]]
    [re-frame.core :as re-frame]
    [comp.mui :as mui]
    [fieldinfo.subs :as subs]
    [fieldinfo.handlers]))

(defn field-name [field]
  (let [symbol (:symbol field)
        name (:name field)
        desc (re-frame/subscribe [::subs/fieldinfo symbol])]
    [:span
     [mui/tooltip {:title  (str symbol ": \r\n" @desc)
                   :placement "right-start"
                   :on-open  (fn [] (do (println "tooltip onOpen" symbol)
                                         (re-frame.core/dispatch [:fieldinfo-request-data symbol])
                                         ))
                   :on-close (fn [] (println "tooltip onClose" symbol))}
      [:span name]
      ]]))
