(ns fieldinfo.handlers
  (:require
    [goog.net.ErrorCode :as errors]
    [ajax.core :refer [GET POST]]
    [re-frame.core :refer [reg-event-db]]
    [api.my-host :refer [create-url]]))

(reg-event-db
  :fieldinfo-request-data
  (fn [db field-symbol]
    (let [symbol (get field-symbol 1)]
     ;; kick off the GET, making sure to supply a callback for success and failure
    (println ":request-fieldinfo " symbol)
    (GET (create-url (str "fieldinfo?symbol=" symbol) )
         {:handler       #(re-frame.core/dispatch [:fieldinfo-process-data symbol %1]) ;; further dispatch !!
          :error-handler #(re-frame.core/dispatch [:bad-response %1])}) ;; further dispatch !!
     db)))    ;; pure handlers must return a db


(reg-event-db
  :fieldinfo-process-data
  (fn [db data]
     (let [field (get data 1)
           description (get data 2)]
           ;(println "RCVD fieldinfo " field description)
           (assoc-in db [:fieldinfo (keyword field)] description)
   )))


(defn xxx []
  (println "...")
  )
