(ns demo.level3
  (:require
    [reagent.core :as r]
    [comp.input :refer [atom-input]]
    ))

(defn level3demo [symbol]
  (let [symbol (r/atom "test")] ;; you can include state
    (r/create-class {
      :display-name  "level3demo"      ;; for more helpful warnings & errors
      :reagent-render ;; let it re-render when the arguments change
        (fn []
          (do (.log js/console (str "render " @symbol))
              [atom-input symbol])) ;; let it re-render when the arguments change
      :component-did-mount
        (fn [comp]
          (do
            (.log js/console "ComponentDidMount")
            (r/dom-node comp)))
      :component-did-update
         (fn [comp]  (.log js/console "ComponentDidUpdate"))

     ;:component-will-receive-props #(home-did-mount % %2) ; (reagent/props %)
     ;:component-did-update ( ;;called just after re-rendering.
     ; fn [this]
     ;     (let [[_ series-values]  (reagent/argv this) ]
     ;          (home-did-mount this series-values)))}))
})))
