(ns demo.cards
  (:require
    ; Load namespaces with `defcard` or `deftest` definitions
    [devcards.core]
    [reagent.core  :as r]
    [sablono.core :as sab])
  (:require-macros
      ;[cljs.test :refer [is testing]]
      [devcards.core :as dc :refer [defcard defcard-rg deftest dom-node]]
      ))


(defonce state (atom {:initial "state"}))

(defcard app-card
  [:h1 "Welcome to Bongistan"]
  state)

;(defcard my-first-card
;  (sab/html [:h1 "Devcards is freaking awesome!"]))

(defcard reagent-no-help
    (r/as-element [:h1 "Reagent example"]))

;; TIMER dev card

(defonce observed-atom
  (let [a (atom 0)]
    (js/setInterval (fn [] (swap! observed-atom inc)) 1000)
   a))

(defcard atom-observing-card observed-atom)


; ATOMS

(defcard
  (fn [data-atom owner]
    (sab/html
      [:div
       [:h3 "Example Counter: " (:count @data-atom)]
       [:button
        {:onClick (fn [] (swap! data-atom update-in [:count] inc))}
        "inc"]]))
    {:count 15}
  {:inspect-data true})

;; REAGENT
(defcard reagent-macro-1
  (dc/reagent [:div "This works fine"]))


(defcard-rg jamming
  [:div {:style {:border "10px solid blue" :padding "20px"}}
    [:h1  "Composing Reagent Hiccup on the fly"]
    [:p "adding arbitrary hiccup"]])


;; REAGENT ATOMS
(defn on-click [ratom]
  (swap! ratom update-in [:count] inc))

(defonce counter2-state (r/atom {:count 0}))

(defn counter2 []
  [:div "Current count: " (@counter2-state :count)
    [:div
      [:button {:on-click #(on-click counter2-state)}
      "Increment"]]])

(defcard-rg counter2
  [counter2] ;; <-- 1
  counter2-state ;; <-- 2
  {:inspect-data true} ;; <-- 3
  )

;; REAGENT MULTIPLE ARGUMENTS

;(defn on-click [ratom]
;  (swap! ratom update-in [:count] inc))

(defonce counter4-state (r/atom {:count 104}))

(defn counter4 [ratom
               {:keys [title button-text]}] ;; <-- counter4 expects two arguments: a ratom, and a hash-map
  [:div [:h3 title]
   [:div "Current count: " (@ratom :count)]
   [:div [:button {:on-click #(on-click ratom)}
          button-text]]])

(defcard-rg counter4
  "multiple arguments passed to reagent"
  [counter4 counter4-state
                       {:title "This is Counter 4"
                        :button-text "INCREMENT"}] ;; <-- passing in two arguments to our reagent component
  counter4-state ;; <-- notice that we are *still* passing in a 2nd argument to defcard!
  {:inspect-data true}
  )


;(defcard contacts
;  (r/as-element [demo.views.contacts]))
