(ns db.instruments
  (:require
    [clojure.string :as str]
    [clojure.java.io :as io]
    [clj-time.core :as t]

    ; Timeseries
    ;[db.csv :refer [symbols-with-timeseries]]
    [series.core :refer [symbols-with-timeseries]]

    ; Instruments
    [mongo.universe :refer [all-instruments]]
 ))


(defn find-instrument [instruments symbol]
  (first(filter #( = (:symbol %) symbol) instruments)))



(defn get-instruments []
  (let [instruments (all-instruments)
        csv-symbols (symbols-with-timeseries)]
    (do
      (def all instruments)
      ; (mapv println csv-symbols)
      (doseq [symbol csv-symbols]
            (let [i (find-instrument all symbol)]
              (when (= i nil)
                  ; (println (str "instrument not yet in db: " symbol ))
                  (def all (conj all {:symbol symbol :name "<Timeseries>"})))))
      ; (def all (conj all {:symbol "z" :name "zzz"}))
       all )))


(defn instrument [symbol]
  (let [instruments (get-instruments)]
  (first(filter #( = (:symbol %) symbol) instruments))))


(comment ;*****************************************************************

(find-instrument [] "x")

(get-instruments)

(instrument "SXRP Index")
(instrument "xx")


) ;*****************************************************************
