(ns comp.table
  (:require
    [reagent.core :as r]
    [comp.mui :as mui]
  )
  (:require-macros
      ;[cljs.test :refer [is testing]]
      [devcards.core :as dc :refer [defcard defcard-rg deftest dom-node]]))


; header is a vector
; 0 - field / hierarchical field def
; 1 - name
; 2 - formatter
; 3 - link formula
; 4 - on-click



(defn get-field-data [header row]
  (let [field (get header 0)
        data (if (vector? field) (get-in row field ) (field row))
        formatter (get header 2)
        text (if (nil? formatter) data (formatter data))
        linker (get header 3)
        href (if (nil? linker) nil (linker row))
        on-click (get header 4)
        ;yy (println "on-click: " on-click)
        ]
    (if (nil? href)  [:span {:on-click #(on-click row) } text]  [:a {:href href} text] )
    ))


(defn my-table
      "material ui table
       headers: vector [field-selector name formatter linker]
       rows: the seq to be displayed as a table"
      [headers rows]

  ;[mui/container {:component "span" }

  [mui/paper {:square true
              :m "lg"
              :style  {:background-color mui/secondary
                       ;; :text-align       :center
                       :padding     "0em 0em 0em 0em"
                       :width "100%"; "400px"
                       :margin-top "10px"
                       :overflow-x "none"
                       ;overflowX: 'auto',
                       :overflow-y "none"
                       :height "200px"
                     }
               }

;   [mui/grid {:container true
;              :style {:overflow-x "auto"
;                      :overflow-y "auto"
;       }}
  ;   [mui/grid {:item true :xs 12}
   ;[:div {} ; Fixes overflow outside screen


  ; https://material-ui.com/api/table/
  [mui/table {:size "small"  ; small or medium
              ;:sticky-header true
              :style {:max-height "200px" }}
  ;; Headers
  [mui/table-head
   (into [mui/table-row]
         (for [field  headers]
              [mui/table-cell (get field 1)]))]
  ;; Body
  (into [mui/table-body]
        (for [row rows]
          (into [mui/table-row]
            (for [field headers]
              [mui/table-cell (get-field-data field row)])
            )))]

            ;]]
  ;          ]
]
            )

; devcard

(def table-fields- [
  [:a "a"]
  [:b "b"]
  [:c "c"]
  [:d "d"]
  [:e "e"]
  [:f "f"]
  [:g "g"]])

(defn make-row- [nr]
   {:a "bongo"
    :e nr
    :g (str "Bongo:" nr)})

(def rows- (map make-row- (range 100)))


(defcard-rg table-helper
    "material-ui table"
    [:div ;  :<>  ;FRAGEMENT does not render to the DOM.
           [my-table table-fields- rows-]
           ]
      )
