(ns comp.key-listener
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [keybind.core :as key]
  ))

(defn key-shortcut-listener [key-binding callback]
  (r/create-class {
    :display-name  "key-shortcut-listener"      ;; for more helpful warnings & errors
    :reagent-render (fn []
        [:span {:class "key-binding"}])

    :component-did-mount (fn [this]
      (do (println "registering " key-binding  )
          (key/bind! key-binding key-binding callback)
        ))
     :component-will-unmount (fn [this]
      (do (println "un-registering " key-binding)
          (key/unbind! key-binding key-binding)
          ))

      :component-did-update (fn [this old-argv]
          (let [new-argv (rest (r/argv this))
                old-argv (rest old-argv)
                key-binding (first old-argv)
                cb-old (last old-argv)
                cb-new (last new-argv)
                ]
               ;(println "old cb " cb-old)
               ;(println "new cb" cb-new)
               (key/unbind! key-binding key-binding)
               (key/bind! key-binding key-binding cb-new)



        ))


   }))
