(ns comp.fetchcomp
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [thi.ng.strf.core :as f]
    [comp.input :refer [atom-input]]
    [helper.reagent :refer [fetch-update]])
  (:require-macros
    [devcards.core :as dc :refer [defcard defcard-rg deftest dom-node]]))

(defn loading-message []
  [:h1 "Loading Data.."])

(defn error-message [error-message]
  [:<>
    [:h1 "Error in Loading Data"]
    [:p error-message]])

(defonce state (r/atom {:api-params nil
                        :result {:data nil}}))

(defn fetch-update-log [db db-location api-endpoint api-params]
    (println "fetchcomp is fetching data..")
    (fetch-update db db-location api-endpoint api-params)
  )

(defn fetch-data-container [api-endpoint api-params view-component]
  ;(let []
  (r/create-class
    {:display-name  "fetchDataContainer"

     ;  http://reagent-project.github.io/docs/master/reagent.core.html#var-create-class

     :get-initial-state (fn [this]
       (println "fetch-comp get-initial-state"))

     ; NEW PROP
     :get-snapshot-before-update (fn [this old-argv new-argv]
       (println "fetch-comp get-snapshot-before-update" )   )

     :should-component-update
        (fn [this old-argv new-argv]
          (let [ [_ api-endpoint api-params view-component] new-argv] ; (r/argv this)]
               ;(println "fetch-comp next-props" (r/props this))
               ;(println "fetch-comp next-args" (r/argv this))
               (println "fetch-comp should-component-update next-api-params" api-params)
               (fetch-update-log state :data api-endpoint api-params)
            ))

     :component-did-mount (fn [this] ; OK
        (println "fetch-comp component-did-mount " api-params)
        (fetch-update-log state :data api-endpoint api-params)
        )

     :component-did-update (fn [this old-argv old-state snapshot]  ; OK
        (let [[_ api-endpoint api-params] (r/argv this)]
            (println "fetch-comp component-did-update: " api-params)
         ))

      :component-will-unmount (fn [this]
        (println "fetch-comp component-will-unmount "))

      :component-did-catch (fn [this error info]
         (println "fetch-comp component-did-catch" ))

     ;: render
     :reagent-render
      (fn [api-endpoint api-params view-component]
        [:<>
          ;::model/loading
          (when (:fetching @state)
             [loading-message])

          (when (:fetch-error @state)
             [error-message (:fetch-error-details @state)])

          (when (and (not (:fetching @state)) (not (:fetch-error @state)))
             [view-component (get-in @state [:result :data])] ) ])

      ; DEPRECIATED
      ;:component-will-receive-props (fn [this]
      ;  (println "fetch-comp component-will-receive-props" api-params))

     ;:component-will-update (fn [this]
       ;  (println "fetch-comp component-will-update" api-params))

       ;:component-will-mount
       ;   #(fetch-update state :data api-endpoint api-params)
 }))


     ; DEV-CARD

(defcard-rg api-fetching-container
  "demo of api-fetching-container"
  (fn []
     [fetch-data-container :bad  {:month 10}   ; this will always fail - useful for testing
        [:h1 (get-in @state [:result :data])]])   )
