(ns cleaning.symbol-change
  (:require
   [mongo.instrument]
   [mongo.series]
   [mongo.report]
   [data.equity-symbol]))


(defn symbol-changed-to [des-notes]
  (when-let [r (re-find #"SEE \{([\w-\\*&//]+)\s(\w+)\s+Equity DES" des-notes)]
    (clojure.string/join " " [(nth r 1) (nth r 2) "Equity"])
    ))

 (defn change-symbol [symbol-old symbol-new]
   (let [c (data.equity-symbol/categorize-symbol symbol-new)]
     (mongo.instrument/change-symbol symbol-old symbol-new)
     ; recalculate symbol-only
     (mongo.instrument/update-instrument {:symbol symbol-new :symbol-only (:symbol-only c)})
     (mongo.series/change-symbol symbol-old symbol-new)
     (mongo.report/change-symbol symbol-old symbol-new)
     ))

(comment
  
  (symbol-changed-to "EFF 1/7/11 -- SEE {BNP CN Equity DES<GO>}")
  (symbol-changed-to "IPO 2/9/06: 21MM SHRS @ C$19.5. ACQUIRED EFFECTIVE 10/06/09 BY CHINA PETROCHEMICAL. SEE {FIFW CACX 38178593}")
  
  
  (change-symbol "ALA-U CN Equity" "ALA CN Equity")
  
  
  )