(ns cleaning.report-year
  (:require
    [clojure.string :as str]
    [clj-time.core :as t]
    [monger.collection :as mc]
    [mongo.db :refer [db]]
    [fundamental.report :refer [extract-year-type-number]]
    ))

; REMOVE Reports that dont have any fields

(defn remove-reports-no-fields []
  (mc/remove db "reports"
             {;:symbol "bongo"
              :fields nil}))

; CALCULATE YEAR+TYPE

(defn reports-test- []
  (mc/find-maps db "reports" {:symbol "OXY US Equity" :year nil} ))

(defn all-reports-no-year []
  (mc/find-maps db "reports" {:year nil} ))

(defn update-year-type [report]
  (let [calculated (extract-year-type-number report)
        _ (println "calculated: " calculated)
        ]
    (if-not (nil? calculated)
      (mc/update-by-id db "reports" (:_id report) {:$set calculated} )
      )))


(defn patch-reports-type []
  (let [reports (all-reports-no-year)
        ;reports (reports-test-)
        ]
    (println "Calculating Year-Type for " (count reports) " Reports.. " )
    ;(println (extract-year-type-number (first reports)))
    (doall (map update-year-type reports))
    (println "# Calculating Year-Type for Reports.. FINISHED!" )
    ))


(comment 

  ; A report that does not have any fields, is of NO USE, so delete it.
  (remove-reports-no-fields)

  ; Calculate Year and Type for all reports, so that we can filter by report type easily.
  (patch-reports-type)


) 

