(ns cleaning.report-scrub
  (:require
    [clojure.java.io :as io]
    [clojure.data :as cljdata]
    [clojure.pprint]
    [clj-time.core :as t]
    [clj-time.format :as fmt]         ; to sanitize report release-date
    [mongo.db :refer [db]]
    [mongo.report :as mreport]
    ))

(def releasedate-format-
  (fmt/formatter "yyyy-M-d H:m:s")) ; 2014-10-21 00:00:00

(def empty-date-string "0001-01-01 00:00:00")

(defn parse-date [date-str]
  (if (= date-str empty-date-string) nil (fmt/parse releasedate-format- date-str)))

(defn scrub-report [report]
  (if (string? (:releasedate report))
    (-> report
         (select-keys [:symbol :period :releasedate])
         (update-in [:releasedate]  parse-date)
         (#(mreport/modify-report %)))
     "ok"))

(defn scrub-reports-raw [reports]
  (doall (map scrub-report reports)))


(defn scrub-reports [symbol]
  (let [;instrument (mongo/load-symbol db symbol)
        reports (mreport/load-reports-for-symbol symbol)
        ;release-dates (get-in instrument [:ERN_ANN_DT_AND_PER])
        ]
    (scrub-reports-raw reports)
    ))

(defn symbols-with-reports []
  (let [overview (mreport/available-report-overview)]
      (binding [*out* (io/writer "reports.txt")]
         (clojure.pprint/print-table overview))))



(comment   ;*********************************************************************

  (symbols-with-reports)

  (fmt/parse releasedate-format- "2014-10-21 00:00:00" )
  (parse-date "2014-10-21 00:00:00" )
  (parse-date empty-date-string )


  (scrub-report {:releasedate "2018-01-10 00:00:00"})
  (scrub-reports-raw  [{:releasedate "2018-01-10 00:00:00"}
                        {:releasedate (t/date-time 2010 04 01)}] )

  (scrub-reports "IIA AV Equity")
  (scrub-reports "MCD UN Equity")


  (pipe scrubbing-reports/scrub-reports  symbols-from-list symbol-list-)
  (pipe scrubbing-reports/scrub-reports  one-symbol symbol-one-)
  (pipe scrubbing-reports/scrub-reports  index symbol-index-)




  ) ;*********************************************************************
