(ns cleaning.duplicateSymbol
  (:require
    [clojure.string :as str]
    [clj-time.core :as t]
    [clojure.tools.logging :as log]
    [monger.collection :as mc]
    [mongo.db :refer [db]]
      ))

(defn duplicate-symbol []
  (mc/aggregate db "instruments" [
    {:$group {:_id  {:symbol "$symbol"}
              :count {:$sum 1}}}
    ;{:$project {:s {:$filter {
    ;   :input "$s"
    ;   :as "s"
    ;   :cond {"$gte" ["$s.count" 2]}} }}}
   ]
))

(comment
(count (duplicate-symbol))
(first (duplicate-symbol))
(clojure.pprint/print-table (filter #(> (:count %) 1) (duplicate-symbol)))
)
