(ns cleaning.composite-exchange
  (:require
    [mongo.db :refer [db]]
    [monger.collection :as mc]
    [data.equity-symbol]
    [cleaning.category]
    ))

; DO NOT USE; THIS NEEDS TO BE MODIFIED. IT DOES NOT WORK CURRENTLY.

(defn equities-no-exchange []
  (mc/find-maps db "instruments" { :category "Equity" :exchange nil } {:symbol 1 :NAME 1}))

(defn update-category [instrument]
  (let [category (data.equity-symbol/separate-category instrument)]
    (if-not
      (nil? category)
      (do (println "updating "(:symbol instrument) " - " category)
          (mc/update db "instruments" {:symbol (:symbol instrument)} {:$set category} {:upsert false})
          )
      (println "no category found for: " (:symbol instrument))
      )))

(defn calculate-categories
  "Category is: 'Index' 'Equity' 'Curncy' 'List', etc.
   To get Instruments by category it is crucial that each instrument has a category.
   This function calculates missing Categories."
  []
  (let [instruments (->> (cleaning.category/instruments-no-category)
                         (remove #(nil? %))
                         (remove #(nil? (:symbol %))))
        ;xx (println instruments)
        ;categories   (map data.equity-symbol/separate-category instruments)
        ;xx (println categories)
        ;          (filter #(in? ["Equity" "Index" "Curncy"] (:category %)))
        ]
    (println "# Instruments without category: " (count instruments))
    (doall (map update-category instruments))
    ;(map #(println "inst: " %) instruments)
    (println "Saving Categories.. DONE!")
    ))



(comment ; ******************************************************************

  (count (equities-no-exchange))
  (nth (equities-no-exchange) 5)

  ; Calculate Category for instruments that do not have a category.
  (update-category  {:symbol "AIF-U CN Equity"})

  (calculate-categories)

  ) ; ******************************************************************
