(ns bloomberg.request.search
  (:require
    [clojure.string :as str]
    [bloomberg.request.request :refer [bloomberg-request-data extract-fields-recursive]]
  ))

(defn capitalize-category [data]
  (update data :category clojure.string/capitalize ))

(defn separate-category
  "extracts Equity/Index/Client/Curncy category from Name<Category>"
  [name-with-category]
  (->> (re-matches #"(.*)<(\w+)>" name-with-category)
        (drop 1)
        (zipmap [:symbol :category ])
        capitalize-category))

(defn split-category [search-row]
    (let [symbol-category (separate-category  (:security search-row))]
        (assoc symbol-category :description (:description search-row) )))

(defn bloomberg-search
  "searches bloomberg symbols"
  [name]
  (->> (bloomberg-request-data "SearchSymbol" ["-q" name])
       (map split-category)))

(comment

;  (separate-category "DAX LN Index")


  ; SEARCH
  (bloomberg-search "russell 2000")

  (let [json (cheshire.core/parse-string (slurp "resources/bbtest/search.json") true)
        rows (map #( extract-fields-recursive %) json)
        xx (println (map :security rows)) ]
        (count rows)
    )

  )
