(ns bloomberg.request.date
  (:require
    [clj-time.core :as t]
    [clj-time.format :as fmt]
    ))

(defn str-2-date [date-as-string]
  ;(println "earnings-date is: " date-as-string)
  (if (or (nil? date-as-string)(= date-as-string "0001-01-01T00:00:00") )
      nil
      (fmt/parse (:date fmt/formatters) (subs date-as-string  0 10))))

(comment
  (fmt/parse (:date fmt/formatters) (subs "2018-10-23T00:00:00" 0 10))
  (fmt/parse "2018-10-23T00:00:00", (fmt/formatter "yyyy-M-d H:m:s"))

  (str-2-date "2018-10-23T00:00:00")
  (str-2-date "2012-06-30T00:00:00")
)
