(ns bloomberg.data.splits
  (:require
    [clj-time.core :as t]
    [bloomberg.request.reference :refer [bloomberg-get-reference-data]]
    ))

; ******* SPECIAL REFERENCE DATA REQUESTS ***************************************************

(defn get-equity-splits
  "gets splits for equity"
  [symbol]
  (-> { :symbol symbol
        :field  "EQY_DVD_HIST_SPLITS"}
      (bloomberg-get-reference-data)))

; "DVD_HIST_ALL" this downloads dividends, splits, spinoffs, right issues, etc

; Id,security,Declared Date,Ex-Date,Record Date,Payable Date,Dividend Amount,Dividend Frequency,Dividend Type
; 0,MO Equity,24.08.2012 00:00:00,12.09.2012 00:00:00,14.09.2012 00:00:00,10.10.2012 00:00:00,0,44,Quarter,Regular Cash
; 18,MO Equity,29.08.2007 00:00:00,31.03.2008 00:00:00,19.03.2008 00:00:00,28.03.2008 00:00:00,1,None,Spinoff
; 64,MO Equity,26.02.1997 00:00:00,11.04.1997 00:00:00,17.03.1997 00:00:00,10.04.1997 00:00:00,3,None,Stock Split
; 74,MO Equity,01.03.1995 00:00:00,09.03.1995 00:00:00,15.03.1995 00:00:00,10.04.1995 00:00:00,0,003333,None,Rights Redemption


(comment

  (get-equity-splits "AAPL US Equity")

  ; SPLIT
  (def split-response (get-equity-splits "MUV2 GY Equity"))  ; "AAPL US Equity"))

  (def split-response (get-equity-splits "IIA AV Equity"))  ; "AAPL US Equity"))

  (println split-response)
  (first split-response)
  (map #(println (:Ex-Date %) (:DividendType %) (:DividendAmount %)) (:EQY_DVD_HIST_SPLITS (first split-response)))

  )
