(ns bloomberg.data.currency
  (:require
    [clojure.string :as str]
    [clj-time.core :as t]
    [clj-time.format :as fmt]
    [bloomberg.request.reference :refer [bloomberg-get-reference-data]]
    [bloomberg.request.date :refer [str-2-date]]
    ))

(defn preprocess-currency-response [response]
  (let [instrument (first response) ]
    (-> instrument
        (clojure.set/rename-keys {:security :symbol
                                  :NAME :name
                                  })
        (assoc :category "Curncy")
        ;(update :MATURITY str-2-date)
        ;(update :LISTED_EXCH  #(map :ExchangeCode %))
        )))


(defn get-currency-info
  "gets currency descriptive data"
  [symbol]
  (-> { :symbol symbol
        :field ["NAME"
                "MARKET_STATUS"
                "SECURITY_TYP"
                ;"ID_ISIN"
                ;ID_CUSIP_ID_NUM
                ;ID_WERTPAPIER;ID_SEDOL1
                ;ID_COMMON
                "ID_BB_GLOBAL"
                ;"ID_BB_COMPANY"
                ;"ID_BB_PRIM_SECURITY_FLAG"
                ;"LISTED_EXCH" ; gives back an array of all exchanges
                "CRNCY"
                ]}
        (bloomberg-get-reference-data)
        (preprocess-currency-response)
        ))

(comment

  (let [ed (get-currency-info "EURUSD Curncy")]
    (println "currency info: " ed))

)
