(ns ^:figwheel-hooks app.quant
  (:require
   [goog.dom :as gdom]
   [reagent.core :as reagent :refer [atom]]
   [re-frame.core :as re-frame]
   [app.init]

   [bongo.config :as config]
   [app.quant.routes :refer [init-routes myroutes-new]]
   [bongo.events :as events]
   [fieldinfo.handlers :as fieldinfo-events]
 ))


; NOTE: The main app has to have a namespace with at least one dot [app.quant].
;       Namespaces without a dot DO NOT WORK IN REAGENT!!!

(defn get-app-element []
  (gdom/getElement "app"))

(defn mount [el]
  (println "mounting application")
  (reagent/render [myroutes-new] el))

(defn mount-app-element []
  (when-let [el (get-app-element)]
    (mount el)))

(defn dev-setup []
  (when config/debug?
    (enable-console-print!)
    (println "dev mode")))

;; specify reload hook with ^;after-load metadata
(defn ^:after-load on-reload []
  (println "on-reload (quant)")
  (app.init/on-reload)
  (mount-app-element)
  ;; optionally touch your app-state to force rerendering depending on
  ;; your application
  ;; (swap! app-state update-in [:__figwheel_counter] inc)
)

(defn on-start []
  (println "my-init")
  (dev-setup)
  (re-frame/dispatch-sync [::events/initialize-db])
  (re-frame/clear-subscription-cache!)
  (events/xxx)
  (fieldinfo-events/xxx)
  (init-routes)
  (app.init/on-start)

  (let [app (get-app-element)]
    (if (nil? app)
        (println "ERROR dom app-element is not present.")
         (println "dom app element is present.")
      ))

  ;; Remove App Loading text
  (when-let [app-elem (js/document.querySelector "#app")]
    (set! (.-innerHTML app-elem)
      (str "")))

  ;; conditionally start your application based on the presence of an "app" element
  ;; this is particularly helpful for testing this ns without launching the app
  (mount-app-element)
)


(on-start)
