(ns ^:figwheel-hooks app.cards
  (:require
    [goog.dom :as gdom]
    [reagent.core :as reagent :refer [atom]]
    [re-frame.core :as re-frame]
    [devcards.core]
    [app.init]

    ; Put here all modules that have defcards
    [demo.cards]
    [demo.views.clock]
    [demo.views.contacts]
    [demo.views.menu]
    [demo.views.controls]
    [demo.views.ozchart]
    [demo.views.aggrid]

    [comp.input]
    [comp.combo]
    [comp.table]
    [comp.highchart]
    [comp.fetch]

    [analysis.symbol]
    [analysis.list]
    [analysis.combined]
    [analysis.app]

    [seasonality.settings]
    [seasonality.instsim]
    [seasonality.listsim]
    [seasonality.precalc]
    [financials.core])
  (:require-macros
    [cljs.test :refer [is testing]]
    [cljss.core]
    [devcards.core :refer [defcard deftest dom-node]]
    ))

;; DEV-CARDS start on :9600/cards.html

;:figwheel {:on-jsload example.core/on-reload}
(defn ^:after-load on-reload
   "after source gets recompiled.
    In ns definition figwheel hooks have to be set (See above)"
  []
    (println "on-reload (dev-cards)! ")
    (app.init/on-reload)
    )

(defn on-start []
  (println "on-start (dev cards)")
  ;; Remove App Loading text
  (when-let [app-elem (js/document.querySelector "#app")]
    (set! (.-innerHTML app-elem)
      (str "")))
  (devcards.core/start-devcard-ui!)
  (app.init/on-start)
  )

(on-start)
