(ns api.get
  (:require
    [clojure.string :as string]
    [api.rest :refer [get-url-internal]]))

; INTERNAL API URL ENDPOINTS definitions

(def api-endpoints {

  :bad "non-valid-request"  ; this will always fail - useful for testing

  ; UNIVERSE
  :instrument "instrument"
  :universe-index-category "index-list"
  :universe-equity-list "equity-list"
  :universe-equity-groups "equity-groups"
  :unverse-search "search"

  ; LIST admin
  :portfolio-list-details "list/details"
  :portfolio-list-add "list/add"
  :portfolio-member-add "list/member-add"
  :portfolio-member-remove "list/member-remove"

  :bloomberg-search "instrument-search"

  ; FINANCIAL REPORTS
  :financial-fields "financial-fields"
  :financial-equity "financials"
  :financial-metrics "series-metrics"
  :financial-metric-series "series-metrics"
  :financial-ratio-stats "ratio-stats"
  :financial-ratio-stats-all "ratio-stats-all"

  ; SEASONALITY
  :seasonal-series "seasonal/timeseries"
  :seasonal-stats "seasonal/series-stats"
  :seasonal-simulate-one "seasonal/simulate-symbol"
  :seasonal-simulate-list "seasonal/simulate-portfolio"
  :seasonal-precalc "seasonal/calculation"
})


(defn get-data
  "make json api request.
   response is passed to callback.
   2 options: a) no query params, b) map that gets converted to query params "
  ([key success]
     (println "get-data url" (key api-endpoints) " no params")
     (get-url-internal (key api-endpoints) success))
  ([key m success]
    (get-data key m success #(println "request to " key " failed.")))
  ([key m success failure]
      (println "get-data url" (key api-endpoints) " params" m )
      (get-url-internal (key api-endpoints) m success failure)))
