(ns analysis.list
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [api.get :refer [get-data]]
    [comp.mui :as mui]
    [comp.combo :refer [combo go-next go-prior]]
    [comp.key-listener :refer [key-shortcut-listener]]
    [styles.ssymbol :refer [portfolio-group]]
    )
  (:require-macros
      [devcards.core :as dc :refer [defcard defcard-rg]]))


(defn portfolio-view [symbol members change-symbol]
  (fn [symbol members change-symbol]
    (let [move-prior #(go-prior symbol members change-symbol)
          move-next #(go-next symbol members change-symbol)
          on-ctrl-right #(do (js/console.log "ctrl-right pressed") (move-next))
          on-ctrl-left #(do (js/console.log "ctrl-left pressed") (move-prior))]
     [portfolio-group ; :<>
        [combo symbol members :symbol change-symbol]
        [:button {:on-click move-prior} "<-"]
        [:button {:on-click move-next} "->"]
        [key-shortcut-listener "ctrl-right" on-ctrl-right]
        [key-shortcut-listener "ctrl-left" on-ctrl-left]
     ])))


(defn portfolio-selector [symbol list change-symbol]
  (let [xx (println "init" symbol list)
        members (r/atom [])
        list-requested (r/atom nil)
        on-portfolio-rcvd (fn [instrument]
          (reset! members (:members instrument))
          (change-symbol (first (:members instrument) ))
          )
        ]
    (fn [symbol list change-symbol]
      (let [fetch-members (fn [symbol-portfolio old]
              (if (not= (compare old symbol-portfolio) 0)
                 (do (reset! list-requested symbol-portfolio)
                     (get-data :portfolio-list-details {:symbol-portfolio symbol-portfolio} on-portfolio-rcvd))))
            ]
      ; gets called when props have changed.
      ;(println "portfolio current: " list "requested: " @list-requested)
      (when list
        (do (fetch-members list @list-requested))
            [portfolio-view symbol @members change-symbol])
  ))))


(defn list-component [state]
  (fn [state]
    (let [symbol {:symbol (:symbol @state) :name (:name @state) }
          list (:portfolio @state)
          change-symbol (fn [s] (do (println "symbol-list rcvd " s)
                                    (swap! state assoc :symbol (:symbol s) :name (:name s) )))]
      [portfolio-selector symbol list change-symbol]
    )))


; DEV-CARD


(def portfolioview-members [{:symbol "ATX" :name "a"} {:symbol "DAX" :name "d"} {:symbol "CAI AV Equity" :name "CA Immo"}])
(defonce portfolioview-state (r/atom {:symbol "DAX" :name "d"}))
(defn portfolioview-setsymbol [symbol-name]
   (println "setting symbol to " symbol-name)
   (swap! portfolioview-state assoc :symbol (:symbol symbol-name)
                                    :name (:name symbol-name)))

(defcard-rg test-portfolio-view
  "test if portfolio view is working"
  (fn []
    [:<>
      [portfolio-view @portfolioview-state portfolioview-members portfolioview-setsymbol]
      [:p "symbol is:" (:symbol @portfolioview-state)]
      ;[:p "name is:" (:name @demosymbol)]
     ])
  portfolioview-state
  {:inspect-data true :history true})


(defonce demolist (r/atom "DAX Index"))
(defonce demosymbol (r/atom nil))

(defn set-symbol [symbol-name]
   ;(.log js/console "You selected: " symbol-name)
   (reset! demosymbol symbol-name))


(defcard-rg list-demo
  "#displays the list selection combo
<br/>     no atoms
<br/>     (callback will return {:symbol :name})"
  (fn [] [:<>
      [:div {:style {:background-color "orange" :display "inline-block"}}
        [:button {:on-click #(reset! demolist nil)} "Empty"]
        [:button {:on-click #(reset! demolist "ATX Index")} "ATX"]
        [:button {:on-click #(reset! demolist "DAX Index")} "DAX"]]
      [portfolio-selector @demosymbol @demolist set-symbol]
      [:p "symbol is:" (:symbol @demosymbol)]
      [:p "name is:" (:name @demosymbol)]]
      )
  demosymbol
  {:inspect-data true :history true})


(defonce appstate (r/atom {:symbol "" :portfolio nil}))

(defcard-rg demo-normal-app-state
  "#list-component using app-state
<br/>  reads :portfolio from app-state
<br/>  writes [:symbol :name] to app-state
<br/>  when portfolio is nil it will not show the portfolio control"
  (fn [] [:<>
      [:div {:style {:background-color "orange" :display "inline-block" }}
        [:button {:on-click #(swap! appstate dissoc :portfolio) } "Empty"]
        [:button {:on-click #(swap! appstate assoc :portfolio "ATX Index") } "ATX"]
        [:button {:on-click #(swap! appstate assoc :portfolio "DAX Index") } "DAX"]]
      [list-component appstate]])
  appstate
  {:inspect-data true :history true})
