(ns analysis.combined
  (:require
    [clojure.string :as string]
    [reagent.core :as r]
    [comp.mui :as mui]
    [comp.table :refer [my-table]]
    [comp.input :refer [atom-input list-selector go-next go-prior]]
    [comp.key-listener :refer [key-shortcut-listener]]
    [api.get :refer [get-data]]
    [analysis.list :refer [list-component]]
    [analysis.symbol :refer [symbol-component]]
    [api.get :refer [get-data]]
    [styles.ssymbol :refer [button-pf]])
  (:require-macros
      ;[cljs.test :refer [is testing]]
      [devcards.core :as dc :refer [defcard defcard-rg]]))


(defn combined-component [state]
  (fn [state]
    (let [portfolio (:portfolio @state)
          portfolio? (not (nil? portfolio))]
    [:<>
      [symbol-component state]
      [button-pf {:portfolio? portfolio?
                  :on-click #(if portfolio?
                               (swap! state dissoc :portfolio)
                               (swap! state assoc :portfolio (:symbol @state)))
                          }
        (if portfolio? "<" ">")]
      [list-component state]]
  )))


(defonce appstate (r/atom {:symbol "" :portfolio "SMI Index"}))

(defcard-rg demo
    ""
    [:div {:style {:background-color "orange"}}
      [combined-component appstate]]
    appstate
    {:inspect-data true :history true})
