;; For a detailed explanation run `lein help tutorial`.
; Great Documentation:
; https://github.com/technomancy/leiningen/blob/master/sample.project.clj

(defproject masterbuilder99.fquant "0.1.2"
  :description "fquant"
  :dependencies 
  [
                 ;Common
   [org.clojure/clojure "1.10.0"]
   [org.clojure/core.async "0.4.474" :exclusions [org.clojure/tools.reader]]
   [clojure-future-spec "1.9.0-beta4"]
   [org.clojure/java.classpath "0.2.3"]
   [org.clojure/tools.namespace "0.2.11"]

   [clj-time "0.14.3"]
   [camel-snake-kebab "0.4.0"]

                 ;Backend
   [environ "1.1.0"]                          ; Environment variables
   [funcool/promesa "1.9.0"]                  ; promises
   [mount "0.1.11"]                           ;start/stop component
   [com.taoensso/tufte "2.0.1"]               ;performance tracking
   
                 ; Database
   [nio "1.0.3"]                              ; SQ-Lite
   [org.clojure/java.jdbc "0.7.5"]            ; SQ-Lite
   [org.xerial/sqlite-jdbc "3.7.2"]           ; SQ-Lite
   [com.novemberain/monger "3.5.0" :exclusions [com.google.guava/guava]] ; mongod OLD 3.1.0
   [capacitor "0.6.0"]                        ; InfluxDB
   [clj-statsd "0.4.0"]                       ; statsd reporting              
   [clj-commons/clj-ssh "0.5.15"]  ; SSH Tunnel
   
                 ; CSV parsing
   [org.clojure/data.csv "0.1.4"]
   [org.clojars.bmabey/csvlib "0.3.6"]
   [ultra-csv "0.2.2"]
   [semantic-csv "0.2.1-alpha1"]

                 ;Data Science
                 ;[tulos/bberg-sdk "3.6.1.0"]; Bloomberg
   [com.stuartsierra/frequencies "0.1.0"]     ; percentile stats
   [incanter/incanter-core "1.9.3"]
   [incanter/incanter-charts "1.9.3"]
                 ;[proto-repl "0.3.1"]                       ; ProtoRepl
                 ;[proto-repl-charts "0.3.2"]                ; ProtoRepl
                 ;[gg4clj "0.1.0"] ; not working
                 ;[gg4clj "0.1.7"] ; R-ggplot in clojure awb99 fork
   [org.clojars.benfb/lein-gorilla "0.6.0"]
   [net.cgrand/xforms "0.18.2"]  ; transducers (for ema sma)
                 ;[quil "2.2.5"]
   [quil "3.0.0"]
                 ;[aprint "0.1.3"]
   [aysylu/loom "0.5.0"]
   [loom-gorilla "0.1.0"]
   [org.clojure/data.xml "0.0.7"]
   [incanter-gorilla "0.1.0"]
                 ;[expresso "0.2.0"]
   [com.lemondronor.leaflet-gorilla "0.1.2"] ; gis data in gorilla
   
   [clj-jgit "0.8.8"]

                 ; Web Server
   [ring "1.7.0"]
   [ring/ring-core "1.7.0"]
   [ring/ring-devel "1.7.0"]
   [ring/ring-jetty-adapter "1.7.0"]          ; needs to match compojure version
   [ring/ring-defaults "0.3.2"]
   [ring/ring-codec "1.1.1"]
   [ring-cors "0.1.12"]                       ; CORS requests
   [compojure "1.6.1"]                        ; Server-Side Routing
   [metosin/compojure-api "1.1.10"]
   [hiccup "1.0.5"]                           ; Templating Server/Side
   [cheshire "5.8.0"]                         ; JSON encoding
   [amalloy/ring-gzip-middleware "0.1.4"]     ; gzip compress responses
   [com.cemerick/url "0.1.1"]

   [clj-http "3.10.0"]  ; http requests
   

   [json-html "0.4.7"]
                 ;; LOGGING DEPS
   [org.clojure/tools.logging "0.2.4"]
   [org.slf4j/slf4j-log4j12 "1.7.1"]
   [log4j/log4j "1.2.17" :exclusions [javax.mail/mail
                                      javax.jms/jms
                                      com.sun.jmdk/jmxtools
                                      com.sun.jmx/jmxri]]
   [ch.qos.logback/logback-core "1.1.2"]
   [ch.qos.logback/logback-classic "1.1.2"]

   
   [com.cemerick/pomegranate "1.1.0"] ; require libraries not yet on disk
   

                 ; Frontend
   [org.clojure/clojurescript "1.10.339"]
                 ;[cljsjs/react "16.4.0-0"]
                 ;[cljsjs/react-dom "16.4.0-0"]
                 ;[binaryage/oops "0.6.2"]
                 ;[com.cognitect/transit-cljs "0.8.243"]
   [hiccups "0.3.0"]
                 ;[cljsjs/jquery "3.2.1-0"]
                 ;[cljsjs/jquery-ui "1.11.4-0"]
   [thi.ng/strf "0.2.2"]
   [noencore "0.3.4"]

   [reagent "0.9.0-rc1"]
                 ;[reagent "0.8.2-SNAPSHOT" :exclusions [cljsjs/react cljsjs/react-dom]] ; reagent has older react references than material-ui
   

   [re-frame "0.10.5"]
   [cljsjs/material-ui-icons "3.0.1-0"]
   [cljsjs/material-ui "3.2.0-0"]   ; https://clojars.org/cljsjs/material-ui/versions/3.2.0-0
   
   [secretary "1.2.3"]                        ; client-side routing
   [cljs-ajax "0.7.3"]                        ; AJAX GET/POST Queries
   [metasoarous/oz "1.4.1"]                   ; Vega Charting Wrapper
   [clj-commons/cljss "1.6.4"] ; Clojure Style Sheets https://github.com/clj-commons/cljss
   [keybind "2.2.0"]
   [devcards "0.2.5"] ; DEV-CARDS
   [sablono "0.8.6"]
   [cljsjs/ag-grid-react "21.0.1-1"]
                 ;[cljsjs/ag-grid-enterprise "21.0.1-0"]
   ]


  ;;; Entry Point
    ;; The -main function in this namespace will be run at launch
    ;; (either via `lein run` or from an uberjar). It should be variadic:
    ;;
    ;; (ns my.service.runner
    ;;   (:gen-class))
    ;;
    ;; (defn -main
    ;;   "Application entry point"
    ;;   [& args]
    ;;   (comment Do app initialization here))
    ;;
    ;; This will be AOT compiled by default; to disable this, attach ^:skip-aot
    ;; metadata to the namespace symbol. ^:skip-aot will not disable AOT
    ;; compilation of :main when :aot is :all or contains the main class. It's
    ;; best to be explicit with the :aot key rather than relying on
    ;; auto-compilation of :main. Setting :main to nil is useful when a
    ;; project contains several main functions. nil will produce a jar
    ;; with manifest.mf that lacks `Main-Class' property.
    ; this is the main entry point to the application? (at least the repl starts there.)
    ; :main ^:skip-aot gorilla-test.core
    ; :aot [ job.stats]
  :main ^:skip-aot main
  ;:main ^:skip-aot user
  
  ; source-paths for clojure
  :source-paths ["src" "test-cljs" "src-client" ] ; cljs dirs-references needed for figwheel
  
  :min-lein-version "2.7.1"

  ;; Plugins are code that runs in Leiningen itself and usually
  ;; provide new tasks or hooks.
  :plugins [[lein-ring "0.12.5"]
            [lein-cljsbuild "1.1.5" :exclusions [[org.clojure/clojure]]]
            [lein-pprint "1.1.1"]
            ;[lein-assoc "0.1.0"]
            ;[s3-wagon-private "1.1.1"]
            [lein-ancient "0.6.15"]
            ;[lein-gorilla "0.4.0"]
            [org.clojars.benfb/lein-gorilla "0.6.0"]
            ]

  :ring {; config of the lein-ring plugin https://github.com/weavejester/lein-ring
         :handler web.app/app
         :init    ring/my-ring-init
         }

  :cljsbuild {
              :builds [
                       ; Development Build
                       {:id           "dev"
                        :source-paths ["src-client"]
                        :compiler     {:main                 app.quant
                                       :verbose              true
                                       :asset-path           "js/compiled/out"
                                       :output-to            "resources/public/js/compiled/quant-dev.js"
                                       :output-dir           "resources/public/js/compiled/quant"
                                       :source-map-timestamp true
                                       :externs              ["externs.js"] ; needed for highcharts.
                                       :preloads             [devtools.preload]
                                       }
                        }

                       ; Cards Build
                       {:id           "cards"
                        :source-paths ["src-client"]
                        :compiler     {:main                 app.cards
                                       :verbose              true
                                       :asset-path           "js/compiled/out"
                                       :output-to            "resources/public/js/compiled/cards.js"
                                       :output-dir           "resources/public/js/compiled/cards"
                                       :source-map-timestamp true
                                       :externs              ["externs.js"] ; needed for highcharts.
                                       :preloads             [devtools.preload]
                                       }
                        }

                       ;Production build
                       {:id           "min"
                        :source-paths ["src-client"]
                        :compiler     {:main                 app.quant
                                       :asset-path           "js/compiled/out"
                                       :output-to            "resources/public/cljs-out/quant-prod.js"
                                       :source-map-timestamp true
                                       :optimizations :advanced
                                       :closure-defines {goog.DEBUG false}
                                       :pretty-print false
                                       :externs              ["externs.js"] ; needed for highcharts.
                                       ;:preloads             [devtools.preload]
                                       }}
                       ]}


  :aliases {"fig"       ["trampoline" "run" "-m" "figwheel.main"]
            "fig:build" ["trampoline" "run" "-m" "figwheel.main" "-b" "dev" "-r"]
            "fig:cards" ["trampoline" "run" "-m" "figwheel.main" "-b" "cards" "-r"]
            "fig:min"   ["run" "-m" "figwheel.main" "-O" "advanced" "-bo" "dev"]
            "fig:test"  ["run" "-m" "figwheel.main" "-co" "test.cljs.edn" "-m" hello-world.test-runner]}


  ;;; Profiles
  ;; Each active profile gets merged into the project map. The :dev
  ;; and :user profiles are active by default, but the latter should be
  ;; looked up in ~/.lein/profiles.clj rather than set in project.clj.
  ;; Use the with-profiles higher-order task to run a task with a
  ;; different set of active profiles.
  ;; See `lein help profiles` for a detailed explanation.
  
  :profiles {
    ;; activated automatically during uberjar
    ; jar contains only code
    ; UberJar contains code plus resources
             :uberjar {:aot :all}

    ;; activated by default
             :dev { ; Figwheel-Main https://figwheel.org
           ; :dev profile which is enabled by default
                   :dependencies  [
                                   [com.bhauman/figwheel-main "0.2.0"]
               ;; optional but recommended
                                   [com.bhauman/rebel-readline-cljs "0.1.4"]
               ;[proto-repl "0.3.1"]
                                   [clj-stacktrace "0.2.4"]
                                   ]
                   :resource-paths ["profiles/dev/resources"]
                   :source-paths ["profiles/dev/src" ]
                   }

             :devnone {
                       :source-paths ["profiles/devnone"]
                       }


             }

   ;;; Repl
  ;; Options to change the way the REPL behaves.
  :repl-options { ;; Specify the string to print when prompting for input.
                 ;; defaults to something like (fn [ns] (str *ns* "=> "))
                 :prompt (fn [ns] (str "your command for <" ns ">? " ))
                 ;; What to print when the repl session starts.
                 :welcome (println "Welcome to the magical world of the repl!")
                 ;; Specify the ns to start the REPL in (overrides :main in
                 ;; this case only)
                 :init-ns myrepl
                 ;; This expression will run when first opening a REPL, in the
                 ;; namespace from :init-ns or :main if specified.
                 ;;:init (println "here we are in" *ns*)
                 :init (myhelp)
                 ;; Print stack traces on exceptions (highly recommended, but
                 ;; currently overwrites *1, *2, etc).
                 :caught clj-stacktrace.repl/pst+
                 ;; Skip's the default requires and printed help message.
                 :skip-default-init false
                 ;; Customize the socket the repl task listens on and
                 ;; attaches to.
                 :host "0.0.0.0"
                ; :port 14001
                 ;; If nREPL takes too long to load it may timeout,
                 ;; increase this to wait longer before timing out.
                 ;; Defaults to 30000 (30 seconds)
                 :timeout 40000
                 ;; nREPL server customization
                 ;; Only one of #{:nrepl-handler :nrepl-middleware}
                 ;; may be used at a time.
                 ;; Use a different server-side nREPL handler.
                ;;  :nrepl-handler (nrepl.server/default-handler)
                 ;; Add server-side middleware to nREPL stack.
                ;; :nrepl-middleware [my.nrepl.thing/wrap-amazingness
                ;;                    ;; TODO: link to more detailed documentation.
                ;;                    ;; Middleware without appropriate metadata
                ;;                    ;; (see nrepl.middleware/set-descriptor!
                ;;                    ;; for details) will simply be appended to the stack
                ;;                    ;; of middleware (rather than ordered based on its
                ;;                    ;; expectations and requirements).
                ;;                    (fn [handler]
                ;;                      (fn [& args]
                ;;                        (prn :middle args)
                ;;                        (apply handler args)))]
                 }
  
  :repositories [["clojars" {:url "https://clojars.org/repo"
                             :username "awb99"
                             :sign-releases false}]]


  )
