# mascip.debug

Debugging functions, for printing data transformations along threading chains `->>` and function composition chains `(some (function (and (another`.

## Usage

    (showc ; If you delete this line, nothing will be printed
      (-> [1 2 3]              (c "input")
          (reverse)            (c "reverse")
          (conj "some text")   (c "add text")
    ))
    => input
       [1 2 3]
       reverse
       (3 2 1)
       add text
       ("some text" 3 2 1)
    
    
    (* 7 (dbg (+ 1 (inc 1))))
    => dbg: (+ 1 (inc 1)) => 3

## The (c) functions

I used to add comments at the end of complex lines, in the middle of a threading chain (->>). Now have this instead of the comments:

    `(c "what this line does")`

It doesn't do anything, it's like a comment. But if you enclose it inside a `(showc   )` block, then it prints you comment, followed by the printed data structure obtained on that line.

There is (c) for -> chains, and (cc) for ->> chains (they do the same thing, but take arguments in a different order).

You can also turn `(c "text")` into `(cs "text")` to get that particular statement to print its text and incoming data.

If some line returns a lazy structure, you can use `(cl)` (or `(ccl)`) to get the data


## Acknowledgements

 - The (c) function is inspired by Micheal Feather's c function for Ruby, in his article \"Literate Chains for Functional Programming\"

 - (dbg) was found in the article \"Conditioning the REPL\" by John Lawrence Aspden"

## License

Copyright © 2014 FIXME

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
